/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.Set;

public final class RoutingUtils {
    private RoutingUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Avoid direct instantiation");
    }

    public static String getNormalizedAndDecodedPath(RoutingContext ctx) {
        String normalizedPath = ctx.normalizedPath();
        if (normalizedPath.contains("?")) {
            return null;
        }
        return URI.create(normalizedPath).getPath();
    }

    public static String resolvePath(RoutingContext ctx) {
        String path = RoutingUtils.getNormalizedAndDecodedPath(ctx);
        if (path == null) {
            return null;
        }
        return ctx.mountPoint() == null ? path : path.substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length());
    }

    public static void compressIfNeeded(HttpBuildTimeConfig config, Set<String> compressMediaTypes, RoutingContext ctx, String path) {
        if (config.enableCompression && RoutingUtils.isCompressed(compressMediaTypes, path)) {
            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
        }
    }

    private static boolean isCompressed(Set<String> compressMediaTypes, String path) {
        if (compressMediaTypes.isEmpty()) {
            return false;
        }
        Object resourcePath = path.endsWith("/") ? path + "index.html" : path;
        String contentType = MimeMapping.getMimeTypeForFilename((String)resourcePath);
        return contentType != null && compressMediaTypes.contains(contentType);
    }
}

