/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.utilities.OS;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class LauncherUtil {
    public static final int LOG_CHECK_INTERVAL = 50;

    private LauncherUtil() {
    }

    @Deprecated(forRemoval=true, since="3.17")
    public static Config installAndGetSomeConfig() {
        return ConfigProvider.getConfig();
    }

    static Process launchProcessAndDrainIO(List<String> args, Map<String, String> env) throws IOException {
        Process process = LauncherUtil.launchProcess(args, env);
        new Thread(new ProcessReader(process.getInputStream())).start();
        new Thread(new ProcessReader(process.getErrorStream())).start();
        return process;
    }

    static Process launchProcess(List<String> args, Map<String, String> env) throws IOException {
        Process process;
        if (env.isEmpty()) {
            process = Runtime.getRuntime().exec(args.toArray(new String[0]));
        } else {
            Map<String, String> currentEnv = System.getenv();
            HashMap<String, String> finalEnv = new HashMap<String, String>(currentEnv);
            finalEnv.putAll(env);
            String[] envArray = new String[finalEnv.size()];
            int i = 0;
            for (Map.Entry entry : finalEnv.entrySet()) {
                envArray[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                ++i;
            }
            process = Runtime.getRuntime().exec(args.toArray(new String[0]), envArray);
        }
        return process;
    }

    static ListeningAddress waitForCapturedListeningData(Process quarkusProcess, Path logFile, long waitTimeSeconds) {
        LauncherUtil.ensureProcessIsAlive(quarkusProcess);
        CountDownLatch signal = new CountDownLatch(1);
        AtomicReference<ListeningAddress> resultReference = new AtomicReference<ListeningAddress>();
        CaptureListeningDataReader captureListeningDataReader = new CaptureListeningDataReader(logFile, Duration.ofSeconds(waitTimeSeconds), signal, resultReference);
        new Thread((Runnable)captureListeningDataReader, "capture-listening-data").start();
        try {
            signal.await(waitTimeSeconds + 2L, TimeUnit.SECONDS);
            ListeningAddress result = resultReference.get();
            if (result != null) {
                return result;
            }
            LauncherUtil.destroyProcess(quarkusProcess);
            throw new IllegalStateException("Unable to determine the status of the running process. See the above logs for details");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting to capture listening process port and protocol");
        }
    }

    private static void ensureProcessIsAlive(Process quarkusProcess) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ignored) {
            throw new RuntimeException("Interrupted while waiting to determine the status of process '" + quarkusProcess.pid() + "'.");
        }
        if (!quarkusProcess.isAlive()) {
            int exit = quarkusProcess.exitValue();
            String message = "Unable to successfully launch process '" + quarkusProcess.pid() + "'. Exit code is: '" + exit + "'.";
            if (OS.determineOS().equals((Object)OS.MAC) && exit == 126) {
                message = message + System.lineSeparator() + "This may be caused by building the native binary in a Linux container while the host is macOS.";
            }
            throw new RuntimeException(message);
        }
    }

    static void destroyProcess(Process quarkusProcess) {
        quarkusProcess.destroy();
        int i = 0;
        while (i++ < 10) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (quarkusProcess.isAlive()) continue;
        }
        if (quarkusProcess.isAlive()) {
            quarkusProcess.destroyForcibly();
        }
    }

    static void destroyProcess(ProcessHandle quarkusProcess) {
        try {
            CompletableFuture<ProcessHandle> exit = quarkusProcess.onExit();
            if (!quarkusProcess.destroy()) {
                quarkusProcess.destroyForcibly();
                return;
            }
            exit.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (quarkusProcess.isAlive()) {
            quarkusProcess.destroyForcibly();
        }
    }

    static void destroyProcess(Process process, boolean children) {
        if (!children) {
            LauncherUtil.destroyProcess(process);
            return;
        }
        process.descendants().forEach(p -> LauncherUtil.destroyProcess(p));
        LauncherUtil.destroyProcess(process);
    }

    static Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> createStartedFunction() {
        ArrayList<IntegrationTestStartedNotifier> startedNotifiers = new ArrayList<IntegrationTestStartedNotifier>();
        for (IntegrationTestStartedNotifier i : ServiceLoader.load(IntegrationTestStartedNotifier.class)) {
            startedNotifiers.add(i);
        }
        if (startedNotifiers.isEmpty()) {
            return null;
        }
        return ctx -> {
            for (IntegrationTestStartedNotifier startedNotifier : startedNotifiers) {
                IntegrationTestStartedNotifier.Result result = startedNotifier.check((IntegrationTestStartedNotifier.Context)ctx);
                if (!result.isStarted()) continue;
                return result;
            }
            return IntegrationTestStartedNotifier.Result.NotStarted.INSTANCE;
        };
    }

    static IntegrationTestStartedNotifier.Result waitForStartedFunction(Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> startedFunction, Process quarkusProcess, long waitTimeSeconds, Path logFile) {
        long bailout = System.currentTimeMillis() + waitTimeSeconds * 1000L;
        IntegrationTestStartedNotifier.Result result = null;
        SimpleContext context = new SimpleContext(logFile);
        while (System.currentTimeMillis() < bailout) {
            if (!quarkusProcess.isAlive()) {
                throw new RuntimeException("Failed to start target quarkus application, process has exited");
            }
            try {
                Thread.sleep(100L);
                result = startedFunction.apply(context);
                if (!result.isStarted()) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (result == null) {
            LauncherUtil.destroyProcess(quarkusProcess);
            throw new RuntimeException("Unable to start target quarkus application " + waitTimeSeconds + "s");
        }
        return result;
    }

    static void updateConfigForPort(Integer effectivePort) {
        if (effectivePort != null) {
            System.setProperty("quarkus.http.port", effectivePort.toString());
            System.setProperty("quarkus.http.test-port", effectivePort.toString());
            System.clearProperty("test.url");
            System.setProperty("test.url", TestHTTPResourceManager.getUri());
        }
    }

    private static class ProcessReader
    implements Runnable {
        private final InputStream inputStream;

        private ProcessReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            byte[] b = new byte[100];
            try {
                int i;
                while ((i = this.inputStream.read(b)) > 0) {
                    System.out.print(new String(b, 0, i, StandardCharsets.UTF_8));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class CaptureListeningDataReader
    implements Runnable {
        private final Path processOutput;
        private final Duration waitTime;
        private final CountDownLatch signal;
        private final AtomicReference<ListeningAddress> resultReference;
        private final Pattern listeningRegex = Pattern.compile("Listening on:\\s+(https?)://[^:]*:(\\d+)");
        private final Pattern startedRegex = Pattern.compile(".*Quarkus .* started in \\d+.*s.*");

        public CaptureListeningDataReader(Path processOutput, Duration waitTime, CountDownLatch signal, AtomicReference<ListeningAddress> resultReference) {
            this.processOutput = processOutput;
            this.waitTime = waitTime;
            this.signal = signal;
            this.resultReference = resultReference;
        }

        @Override
        public void run() {
            if (!this.ensureProcessOutputFileExists()) {
                this.unableToDetermineData("Log file '" + this.processOutput.toAbsolutePath() + "' was not created. Check if the options quarkus.log.level and quarkus.log.file.level are at least INFO (or more verbose).");
                return;
            }
            long bailoutTime = System.currentTimeMillis() + this.waitTime.toMillis();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.processOutput.toFile()));){
                long timeStarted = Long.MAX_VALUE;
                boolean started = false;
                while (true) {
                    if (reader.ready()) {
                        Matcher regexMatcher;
                        String line = reader.readLine();
                        if (this.startedRegex.matcher(line).matches()) {
                            timeStarted = System.currentTimeMillis();
                            started = true;
                        }
                        if ((regexMatcher = this.listeningRegex.matcher(line)).find()) {
                            this.dataDetermined(regexMatcher.group(1), Integer.valueOf(regexMatcher.group(2)));
                            return;
                        }
                        if (!line.contains("Failed to start application (with profile")) continue;
                        this.unableToDetermineData("Application was not started: " + line);
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (now + 50L > bailoutTime || now - 100L > timeStarted) {
                        if (started) {
                            this.dataDetermined(null, null);
                        } else {
                            this.unableToDetermineData("Waited " + this.waitTime.getSeconds() + " seconds for " + this.processOutput + " to contain info about the listening port and protocol but no such info was found. Check if the options quarkus.log.level and quarkus.log.file.level are at least INFO (or more verbose).");
                        }
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.unableToDetermineData("Thread interrupted while waiting for more data to become available in process output file: " + this.processOutput.toAbsolutePath());
                        reader.close();
                        return;
                    }
                }
            }
            catch (Exception e) {
                this.unableToDetermineData("Exception occurred while reading process output from file " + this.processOutput);
                e.printStackTrace();
                return;
            }
        }

        private boolean ensureProcessOutputFileExists() {
            long bailoutTime = System.currentTimeMillis() + this.waitTime.toMillis();
            while (System.currentTimeMillis() < bailoutTime) {
                if (Files.exists(this.processOutput, new LinkOption[0])) {
                    return true;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.unableToDetermineData("Thread interrupted while waiting for process output file to be created");
                    return false;
                }
            }
            return false;
        }

        private void dataDetermined(String protocolValue, Integer portValue) {
            this.resultReference.set(new ListeningAddress(portValue, protocolValue));
            this.signal.countDown();
        }

        private void unableToDetermineData(String errorMessage) {
            System.err.println(errorMessage);
            this.resultReference.set(null);
            this.signal.countDown();
        }
    }

    private static class SimpleContext
    implements IntegrationTestStartedNotifier.Context {
        private final Path logFile;

        public SimpleContext(Path logFile) {
            this.logFile = logFile;
        }

        @Override
        public Path logFile() {
            return this.logFile;
        }
    }
}

