/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cache;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.cache.CacheInvalidate;
import io.quarkus.cache.CacheInvalidateAll;
import io.quarkus.cache.CacheResult;
import io.quarkus.spring.cache.SpringCacheProcessor;
import io.quarkus.spring.cache.SpringCacheUtil;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class SpringCacheAnnotationsTransformer
implements AnnotationsTransformer {
    private static final Logger LOGGER = Logger.getLogger(SpringCacheAnnotationsTransformer.class);
    private static final DotName CACHE_RESULT_INTERCEPTOR_BINDING = DotName.createSimple((String)CacheResult.class.getName());
    private static final DotName CACHE_INVALIDATE_INTERCEPTOR_BINDING = DotName.createSimple((String)CacheInvalidate.class.getName());
    private static final DotName CACHE_INVALIDATE_ALL_INTERCEPTOR_BINDING = DotName.createSimple((String)CacheInvalidateAll.class.getName());

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.METHOD;
    }

    public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
        AnnotationTarget target = transformationContext.getTarget();
        if (target.kind() != AnnotationTarget.Kind.METHOD) {
            return;
        }
        MethodInfo methodInfo = target.asMethod();
        if (methodInfo.hasAnnotation(SpringCacheProcessor.CACHEABLE)) {
            AnnotationInstance cacheable = methodInfo.annotation(SpringCacheProcessor.CACHEABLE);
            Optional<String> cacheName = SpringCacheUtil.getSpringCacheName(cacheable);
            if (cacheName.isPresent()) {
                ((Transformation)transformationContext.transform().add(CACHE_RESULT_INTERCEPTOR_BINDING, new AnnotationValue[]{AnnotationValue.createStringValue((String)"cacheName", (String)cacheName.get())})).done();
            } else {
                this.warnAboutMissingCacheName(cacheable, methodInfo);
            }
        } else if (methodInfo.hasAnnotation(SpringCacheProcessor.CACHE_EVICT)) {
            AnnotationInstance cacheEvict = methodInfo.annotation(SpringCacheProcessor.CACHE_EVICT);
            Optional<String> cacheName = SpringCacheUtil.getSpringCacheName(cacheEvict);
            if (!cacheName.isPresent()) {
                this.warnAboutMissingCacheName(cacheEvict, methodInfo);
                return;
            }
            AnnotationValue allEntriesValue = cacheEvict.value("allEntries");
            boolean allEntries = false;
            if (allEntriesValue != null) {
                allEntries = allEntriesValue.asBoolean();
            }
            ((Transformation)transformationContext.transform().add(allEntries ? CACHE_INVALIDATE_ALL_INTERCEPTOR_BINDING : CACHE_INVALIDATE_INTERCEPTOR_BINDING, new AnnotationValue[]{AnnotationValue.createStringValue((String)"cacheName", (String)cacheName.get())})).done();
        } else if (methodInfo.hasAnnotation(SpringCacheProcessor.CACHE_PUT)) {
            AnnotationInstance cachePut = methodInfo.annotation(SpringCacheProcessor.CACHE_PUT);
            Optional<String> cacheName = SpringCacheUtil.getSpringCacheName(cachePut);
            if (cacheName.isPresent()) {
                ((Transformation)((Transformation)transformationContext.transform().add(CACHE_RESULT_INTERCEPTOR_BINDING, new AnnotationValue[]{AnnotationValue.createStringValue((String)"cacheName", (String)cacheName.get())})).add(CACHE_INVALIDATE_INTERCEPTOR_BINDING, new AnnotationValue[]{AnnotationValue.createStringValue((String)"cacheName", (String)cacheName.get())})).done();
            } else {
                this.warnAboutMissingCacheName(cachePut, methodInfo);
            }
        }
    }

    private void warnAboutMissingCacheName(AnnotationInstance instance, MethodInfo methodInfo) {
        LOGGER.warn((Object)(instance + " has no specified cache name, so it will be ignored. Offending method is '" + methodInfo.name() + "' of class '" + methodInfo.declaringClass().name().toString() + "'"));
    }
}

