/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.pulsar.deployment;

import io.quarkus.smallrye.reactivemessaging.deployment.SmallRyeReactiveMessagingProcessor;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelDirection;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorManagedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.DotNames;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.SyntheticBeanBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

class DefaultSchemaDiscoveryState {
    private final IndexView index;
    private final Map<String, Boolean> isPulsarConnector = new HashMap<String, Boolean>();
    private final Set<String> alreadyConfigured = new HashSet<String>();
    private Boolean connectorHasSchema;

    DefaultSchemaDiscoveryState(IndexView index) {
        this.index = index;
    }

    Config getConfig() {
        return ConfigProvider.getConfig();
    }

    boolean isPulsarConnector(List<ConnectorManagedChannelBuildItem> channelsManagedByConnectors, boolean incoming, String channelName) {
        Optional<ConnectorManagedChannelBuildItem> match = channelsManagedByConnectors.stream().filter(cn -> cn.getDirection() == (incoming ? ChannelDirection.INCOMING : ChannelDirection.OUTGOING) && cn.getName().equalsIgnoreCase(channelName)).findFirst();
        if (match.isPresent()) {
            return true;
        }
        String channelType = incoming ? "incoming" : "outgoing";
        return this.isPulsarConnector.computeIfAbsent(channelType + "|" + channelName, ignored -> {
            String connectorKey = SmallRyeReactiveMessagingProcessor.getChannelPropertyKey((String)channelName, (String)"connector", (boolean)incoming);
            String connector = this.getConfig().getOptionalValue(connectorKey, String.class).orElse("ignored");
            return "smallrye-pulsar".equals(connector);
        });
    }

    boolean shouldNotConfigure(String key) {
        if (key.startsWith("mp.messaging.outgoing.") && key.endsWith(".schema")) {
            if (this.connectorHasSchema == null) {
                this.connectorHasSchema = this.getConfig().getOptionalValue("mp.messaging.connector.smallrye-pulsar.schema", String.class).isPresent();
            }
            return this.connectorHasSchema;
        }
        if (key.startsWith("mp.messaging.incoming.") && key.endsWith(".schema")) {
            if (this.connectorHasSchema == null) {
                this.connectorHasSchema = this.getConfig().getOptionalValue("mp.messaging.connector.smallrye-pulsar.schema", String.class).isPresent();
            }
            return this.connectorHasSchema;
        }
        return false;
    }

    void ifNotYetConfigured(String key, Runnable runnable) {
        if (!this.alreadyConfigured.contains(key)) {
            this.alreadyConfigured.add(key);
            runnable.run();
        }
    }

    boolean isAvroGenerated(DotName className) {
        ClassInfo clazz = this.index.getClassByName(className);
        return clazz != null && clazz.declaredAnnotation(DotNames.AVRO_GENERATED) != null;
    }

    boolean isProtobufGenerated(DotName className) {
        ClassInfo clazz = this.index.getClassByName(className);
        return clazz != null && Objects.equals(clazz.superName(), DotNames.PROTOBUF_GENERATED);
    }

    boolean hasObjectMapperConfigSchema(Type type, String channelName, boolean incoming) {
        String key = SmallRyeReactiveMessagingProcessor.getChannelPropertyKey((String)channelName, (String)"schema", (boolean)incoming);
        Optional schema = this.getConfig().getOptionalValue(key, String.class);
        return schema.isPresent() && ((String)schema.get()).equals(SyntheticBeanBuilder.objectMapperSchemaId(type));
    }

    List<AnnotationInstance> findAnnotationsOnMethods(DotName annotation) {
        return this.index.getAnnotations(annotation).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.METHOD).collect(Collectors.toList());
    }

    List<AnnotationInstance> findRepeatableAnnotationsOnMethods(DotName annotation) {
        return this.index.getAnnotationsWithRepeatable(annotation, this.index).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.METHOD).collect(Collectors.toList());
    }

    List<AnnotationInstance> findAnnotationsOnInjectionPoints(DotName annotation) {
        return this.index.getAnnotations(annotation).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.FIELD || it.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.toList());
    }

    List<AnnotationInstance> findProvidedSchemaWithIdentifier(String identifier) {
        return this.index.getAnnotations(DotNames.IDENTIFIER).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.FIELD || it.target().kind() == AnnotationTarget.Kind.METHOD).filter(a -> a.target().hasAnnotation(DotNames.PRODUCES)).filter(a -> {
            AnnotationTarget target = a.target();
            if (target.kind() == AnnotationTarget.Kind.FIELD) {
                return target.asField().type().name().equals((Object)DotNames.PULSAR_SCHEMA);
            }
            if (target.kind() == AnnotationTarget.Kind.METHOD) {
                return target.asMethod().returnType().name().equals((Object)DotNames.PULSAR_SCHEMA);
            }
            return false;
        }).filter(a -> Objects.equals(identifier, a.value().asString())).collect(Collectors.toList());
    }

    List<ClassInfo> findImplementedSchemaWithIdentifier(String identifier) {
        return this.index.getAllKnownImplementors(DotNames.PULSAR_SCHEMA).stream().filter(t -> t.hasAnnotation(DotNames.IDENTIFIER) && Objects.equals(t.annotation(DotNames.IDENTIFIER).value().asString(), identifier)).collect(Collectors.toList());
    }
}

