/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.vertx.core.Vertx;
import jakarta.inject.Singleton;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@Singleton
public class QuarkusAsyncHealthCheckFactory
extends AsyncHealthCheckFactory {
    private final Vertx vertx;

    public QuarkusAsyncHealthCheckFactory(Vertx vertx) {
        this.vertx = vertx;
    }

    public Uni<HealthCheckResponse> callSync(HealthCheck healthCheck) {
        Uni healthCheckResponseUni = super.callSync(healthCheck);
        return BlockingOperationControl.isBlockingAllowed() ? healthCheckResponseUni : healthCheckResponseUni.runSubscriptionOn(MutinyHelper.blockingExecutor((Vertx)this.vertx));
    }

    public Uni<HealthCheckResponse> callAsync(AsyncHealthCheck asyncHealthCheck) {
        Uni healthCheckResponseUni = super.callAsync(asyncHealthCheck);
        return !BlockingOperationControl.isBlockingAllowed() ? healthCheckResponseUni : healthCheckResponseUni.runSubscriptionOn(MutinyHelper.executor((Vertx)this.vertx));
    }
}

