/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.sortedset.ReactiveZScanCursor;
import io.quarkus.redis.datasource.sortedset.ScoredValue;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ZScanReactiveCursorImpl<V>
extends AbstractRedisCommands
implements ReactiveZScanCursor<V> {
    private final byte[] key;
    private final Type typeOfValue;
    private long cursor;
    private boolean initial;
    private final List<String> extra = new ArrayList<String>();

    public <K> ZScanReactiveCursorImpl(RedisCommandExecutor redis, K key, Marshaller marshaller, Type typeOfValue, List<String> extra) {
        super(redis, marshaller);
        this.key = marshaller.encode(key);
        this.cursor = 0L;
        this.initial = true;
        this.typeOfValue = typeOfValue;
        this.extra.addAll(extra);
    }

    @Override
    public boolean hasNext() {
        return this.initial || this.cursor != 0L;
    }

    @Override
    public Uni<List<ScoredValue<V>>> next() {
        this.initial = false;
        return this.execute(RedisCommand.of(Command.ZSCAN).put(this.key).put(Long.toUnsignedString(this.cursor)).putAll(this.extra)).invoke(response -> {
            this.cursor = Long.parseUnsignedLong(response.get(0).toString());
        }).map(response -> {
            Response array = response.get(1);
            Object value = null;
            ArrayList<ScoredValue<Object>> list = new ArrayList<ScoredValue<Object>>();
            for (Response nested : array) {
                if (value == null) {
                    value = this.marshaller.decode(this.typeOfValue, nested.toBytes());
                    continue;
                }
                list.add(new ScoredValue<Object>(value, nested.toDouble()));
                value = null;
            }
            return list;
        });
    }

    @Override
    public long cursorId() {
        return this.cursor;
    }

    @Override
    public Multi<ScoredValue<V>> toMulti() {
        return Multi.createBy().repeating().uni(this::next).whilst(m -> this.hasNext()).onItem().transformToMultiAndConcatenate(list -> Multi.createFrom().items(list.stream()));
    }
}

