/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mssql.client.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.mssql.client.deployment.MSSQLPoolBuildItem;
import io.quarkus.reactive.mssql.client.runtime.DataSourcesReactiveMSSQLConfig;
import io.quarkus.reactive.mssql.client.runtime.MSSQLPoolRecorder;
import io.quarkus.reactive.mssql.client.runtime.MsSQLServiceBindingConverter;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mutiny.mssqlclient.MSSQLPool;
import io.vertx.sqlclient.Pool;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;

class ReactiveMSSQLClientProcessor {
    ReactiveMSSQLClientProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<MSSQLPoolBuildItem> msSQLPool, BuildProducer<VertxPoolBuildItem> vertxPool, MSSQLPoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMSSQLConfig dataSourcesReactiveMSSQLConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REACTIVE_MSSQL_CLIENT));
        this.createPoolIfDefined(recorder, vertx, eventLoopCount, shutdown, msSQLPool, vertxPool, syntheticBeans, "<default>", dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMSSQLConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem);
        for (String dataSourceName : dataSourcesBuildTimeConfig.namedDataSources.keySet()) {
            this.createPoolIfDefined(recorder, vertx, eventLoopCount, shutdown, msSQLPool, vertxPool, syntheticBeans, dataSourceName, dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMSSQLConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem);
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.REACTIVE_MSSQL_CLIENT));
        return new ServiceStartBuildItem("reactive-mssql-client");
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.reactive((String)"mssql");
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{MsSQLServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("mssql"));
    }

    @BuildStep
    void addHealthCheck(Capabilities capabilities, BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!capabilities.isPresent("io.quarkus.smallrye.health")) {
            return;
        }
        if (!this.hasPools(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.reactive.mssql.client.runtime.health.ReactiveMSSQLDataSourcesHealthCheck", dataSourcesBuildTimeConfig.healthEnabled));
    }

    private void createPoolIfDefined(MSSQLPoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<MSSQLPoolBuildItem> msSQLPool, BuildProducer<VertxPoolBuildItem> vertxPool, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, String dataSourceName, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMSSQLConfig dataSourcesReactiveMSSQLConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!ReactiveMSSQLClientProcessor.isReactiveMSSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        RuntimeValue pool = recorder.configureMSSQLPool(vertx.getVertx(), eventLoopCount.getEventLoopCount(), dataSourceName, dataSourcesRuntimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMSSQLConfig, (ShutdownContext)shutdown);
        msSQLPool.produce((BuildItem)new MSSQLPoolBuildItem(dataSourceName, (RuntimeValue<io.vertx.mssqlclient.MSSQLPool>)pool));
        SyntheticBeanBuildItem.ExtendedBeanConfigurator msSQLPoolBeanConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mssqlclient.MSSQLPool.class).defaultBean()).addType(Pool.class)).scope(ApplicationScoped.class)).runtimeValue(pool).unremovable()).setRuntimeInit();
        ReactiveMSSQLClientProcessor.addQualifiers(msSQLPoolBeanConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)msSQLPoolBeanConfigurator.done());
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mutinyMSSQLPoolConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MSSQLPool.class).defaultBean()).scope(ApplicationScoped.class)).runtimeValue(recorder.mutinyMSSQLPool(pool)).setRuntimeInit();
        ReactiveMSSQLClientProcessor.addQualifiers(mutinyMSSQLPoolConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)mutinyMSSQLPoolConfigurator.done());
        vertxPool.produce((BuildItem)new VertxPoolBuildItem(pool, "mssql", DataSourceUtil.isDefault((String)dataSourceName)));
    }

    private static boolean isReactiveMSSQLPoolDefined(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, String dataSourceName, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = dataSourcesBuildTimeConfig.getDataSourceRuntimeConfig(dataSourceName);
        DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig = dataSourcesReactiveBuildTimeConfig.getDataSourceReactiveBuildTimeConfig(dataSourceName);
        Optional dbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind, defaultDataSourceDbKindBuildItems, (!DataSourceUtil.isDefault((String)dataSourceName) || dataSourceBuildTimeConfig.devservices.enabled.orElse(dataSourcesBuildTimeConfig.namedDataSources.isEmpty()) != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!dbKind.isPresent()) {
            return false;
        }
        return DatabaseKind.isMsSQL((String)((String)dbKind.get())) && dataSourceReactiveBuildTimeConfig.enabled;
    }

    private boolean hasPools(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (ReactiveMSSQLClientProcessor.isReactiveMSSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, "<default>", defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return true;
        }
        for (String dataSourceName : dataSourcesBuildTimeConfig.namedDataSources.keySet()) {
            if (!ReactiveMSSQLClientProcessor.isReactiveMSSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) continue;
            return true;
        }
        return false;
    }

    private static void addQualifiers(SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator, String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            configurator.addQualifier(DotNames.DEFAULT);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)dataSourceName).done();
            configurator.addQualifier().annotation(ReactiveDataSource.class).addValue("value", (Object)dataSourceName).done();
        }
    }
}

