/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.logstream;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.StreamingLogHandlerBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.logging.LoggingDecorateBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.runtime.logstream.LogStreamBroadcaster;
import io.quarkus.devui.runtime.logstream.LogStreamJsonRPCService;
import io.quarkus.devui.runtime.logstream.LogStreamRecorder;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.util.Map;
import java.util.Optional;

public class LogStreamProcessor {
    private final String namespace = "devui-logstream";

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(LogStreamBroadcaster.class).setUnremovable().build());
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handler(BuildProducer<StreamingLogHandlerBuildItem> streamingLogHandlerBuildItem, LoggingDecorateBuildItem loggingDecorateBuildItem, LogStreamRecorder recorder) {
        RuntimeValue mutinyLogHandler = recorder.mutinyLogHandler(loggingDecorateBuildItem.getSrcMainJava().toString(), loggingDecorateBuildItem.getKnowClasses());
        streamingLogHandlerBuildItem.produce((BuildItem)new StreamingLogHandlerBuildItem(mutinyLogHandler));
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void registerBuildTimeActions(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, LaunchModeBuildItem launchModeBuildItem) {
        Optional ts = TestSupport.instance();
        BuildTimeActionBuildItem keyStrokeActions = new BuildTimeActionBuildItem("devui-logstream");
        keyStrokeActions.actionBuilder().methodName("forceRestart").description("This force a Quarkus application restart (like pressing 's' in the console)").function(ignored -> {
            RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
            return Map.of();
        }).build();
        keyStrokeActions.actionBuilder().methodName("rerunAllTests").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            if (((TestSupport)ts.get()).isStarted()) {
                ((TestSupport)ts.get()).runAllTests();
                return Map.of();
            }
            ((TestSupport)ts.get()).start();
            return Map.of("running", ((TestSupport)ts.get()).isRunning());
        }).build();
        keyStrokeActions.actionBuilder().methodName("rerunFailedTests").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            ((TestSupport)ts.get()).runFailedTests();
            return Map.of();
        }).build();
        keyStrokeActions.actionBuilder().methodName("toggleBrokenOnly").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            boolean brokenOnlyMode = ((TestSupport)ts.get()).toggleBrokenOnlyMode();
            return Map.of("brokenOnlyMode", brokenOnlyMode);
        }).build();
        keyStrokeActions.actionBuilder().methodName("printFailures").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            ((TestSupport)ts.get()).printFullResults();
            return Map.of();
        }).build();
        keyStrokeActions.actionBuilder().methodName("toggleTestOutput").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            boolean isTestOutput = ((TestSupport)ts.get()).toggleTestOutput();
            return Map.of("isTestOutput", isTestOutput);
        }).build();
        keyStrokeActions.actionBuilder().methodName("toggleInstrumentationReload").function(ignored -> {
            boolean instrumentationEnabled = RuntimeUpdatesProcessor.INSTANCE.toggleInstrumentation();
            return Map.of("instrumentationEnabled", instrumentationEnabled);
        }).build();
        keyStrokeActions.actionBuilder().methodName("pauseTests").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            if (((TestSupport)ts.get()).isStarted()) {
                ((TestSupport)ts.get()).stop();
                return Map.of("running", ((TestSupport)ts.get()).isRunning());
            }
            return Map.of();
        }).build();
        keyStrokeActions.actionBuilder().methodName("toggleLiveReload").function(ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            boolean liveReloadEnabled = ((TestSupport)ts.get()).toggleLiveReloadEnabled();
            return Map.of("liveReloadEnabled", liveReloadEnabled);
        }).build();
        buildTimeActionProducer.produce((BuildItem)keyStrokeActions);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem("devui-logstream", LogStreamJsonRPCService.class);
    }

    private boolean testsDisabled(LaunchModeBuildItem launchModeBuildItem, Optional<TestSupport> ts) {
        return ts.isEmpty() || launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL;
    }
}

