/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.proxy.ProxyFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class RecordingProxyFactories {
    private static final Map<Class<?>, ProxyFactory<?>> RECORDING_PROXY_FACTORIES = new ConcurrentHashMap();

    RecordingProxyFactories() {
    }

    static <T> void put(final Class<T> clazz, ProxyFactory<T> proxyFactory) {
        RECORDING_PROXY_FACTORIES.put(clazz, proxyFactory);
        if (clazz.getClassLoader() instanceof QuarkusClassLoader) {
            ((QuarkusClassLoader)clazz.getClassLoader()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    RECORDING_PROXY_FACTORIES.remove(clazz);
                }
            });
        }
    }

    static <T> ProxyFactory<T> get(Class<T> clazz) {
        return RECORDING_PROXY_FACTORIES.get(clazz);
    }
}

