/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.tracker;

import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;

public class ConfigTrackingValueTransformer {
    private static final String NOT_CONFIGURED = "quarkus.config-tracking:not-configured";
    private static final String PATH_ELEMENT_SEPARATOR = "/";
    private static final String USER_HOME_DIR_ALIAS = "~";
    private static volatile MessageDigest SHA512;
    private final String userHomeDir;
    private final List<Pattern> hashOptionsPatterns;

    private static MessageDigest getSHA512() {
        if (SHA512 == null) {
            try {
                SHA512 = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return SHA512;
    }

    public static ConfigTrackingValueTransformer newInstance(Config config) {
        return new ConfigTrackingValueTransformer((ConfigTrackingConfig)((SmallRyeConfig)config.unwrap(SmallRyeConfig.class)).getConfigMapping(ConfigTrackingConfig.class));
    }

    public static ConfigTrackingValueTransformer newInstance(ConfigTrackingConfig config) {
        return new ConfigTrackingValueTransformer(config);
    }

    public static String asString(ConfigValue value) {
        return value == null ? NOT_CONFIGURED : value.getValue();
    }

    private ConfigTrackingValueTransformer(ConfigTrackingConfig config) {
        this.userHomeDir = config.useUserHomeAliasInPaths() ? PropertyUtils.getUserHome() : null;
        this.hashOptionsPatterns = config.getHashOptionsPatterns();
    }

    public String transform(String name, ConfigValue value) {
        return value == null ? NOT_CONFIGURED : this.transform(name, value.getValue());
    }

    public String transform(String name, String original) {
        if (original == null) {
            return NOT_CONFIGURED;
        }
        for (Pattern pattern : this.hashOptionsPatterns) {
            if (!pattern.matcher(name).matches()) continue;
            return ConfigTrackingValueTransformer.sha512(original);
        }
        if (this.userHomeDir != null && original.startsWith(this.userHomeDir)) {
            String relativePath = original.substring(this.userHomeDir.length());
            if (relativePath.isEmpty()) {
                return USER_HOME_DIR_ALIAS;
            }
            if (File.separator.equals(PATH_ELEMENT_SEPARATOR)) {
                return USER_HOME_DIR_ALIAS + relativePath;
            }
            StringJoiner joiner = new StringJoiner(PATH_ELEMENT_SEPARATOR);
            joiner.add(USER_HOME_DIR_ALIAS);
            Path path = Path.of(relativePath, new String[0]);
            for (int i = 0; i < path.getNameCount(); ++i) {
                joiner.add(path.getName(i).toString());
            }
            return joiner.toString();
        }
        return original;
    }

    public static String sha512(String value) {
        return ConfigTrackingValueTransformer.sha512(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha512(byte[] value) {
        byte[] digest = ConfigTrackingValueTransformer.getSHA512().digest(value);
        StringBuilder sb = new StringBuilder(40);
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }
}

