/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.deployment.codegen.CodeGenData;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingValueTransformer;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.config.SmallRyeConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.logging.Logger;

public class CodeGenerator {
    private static final Logger log = Logger.getLogger(CodeGenerator.class);
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final List<String> CONFIG_SERVICES = List.of("org.eclipse.microprofile.config.spi.Converter", "org.eclipse.microprofile.config.spi.ConfigSource", "org.eclipse.microprofile.config.spi.ConfigSourceProvider", "io.smallrye.config.ConfigSourceInterceptor", "io.smallrye.config.ConfigSourceInterceptorFactory", "io.smallrye.config.ConfigSourceFactory", "io.smallrye.config.SecretKeysHandler", "io.smallrye.config.SecretKeysHandlerFactory", "io.smallrye.config.ConfigValidator");

    public static void initAndRun(QuarkusClassLoader classLoader, PathCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar, ApplicationModel appModel, Properties properties, String launchMode, boolean test) throws CodeGenException {
        List<CodeGenData> generators = CodeGenerator.init((ClassLoader)classLoader, sourceParentDirs, generatedSourcesDir, buildDir, sourceRegistrar);
        if (generators.isEmpty()) {
            return;
        }
        LaunchMode mode = LaunchMode.valueOf((String)launchMode);
        Config config = CodeGenerator.getConfig(appModel, mode, properties, classLoader);
        for (CodeGenData generator : generators) {
            generator.setRedirectIO(true);
            CodeGenerator.trigger((ClassLoader)classLoader, generator, appModel, config, test);
        }
    }

    private static List<CodeGenData> init(ClassLoader deploymentClassLoader, PathCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            List<CodeGenProvider> codeGenProviders = CodeGenerator.loadCodeGenProviders(deploymentClassLoader);
            if (codeGenProviders.isEmpty()) {
                return List.of();
            }
            ArrayList<CodeGenData> result = new ArrayList<CodeGenData>(codeGenProviders.size());
            for (CodeGenProvider provider : codeGenProviders) {
                Path outputDir = CodeGenerator.codeGenOutDir(generatedSourcesDir, provider, sourceRegistrar);
                for (Path sourceParentDir : sourceParentDirs) {
                    result.add(new CodeGenData(provider, outputDir, sourceParentDir.resolve(provider.inputDirectory()), buildDir));
                }
            }
            return result;
        });
    }

    public static List<CodeGenData> init(ClassLoader deploymentClassLoader, Collection<DevModeContext.ModuleInfo> modules) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            List<CodeGenProvider> codeGenProviders = null;
            List<CodeGenData> codeGens = List.of();
            for (DevModeContext.ModuleInfo module : modules) {
                if (module.getSourceParents().isEmpty() || module.getPreBuildOutputDir() == null) continue;
                if (codeGenProviders == null && (codeGenProviders = CodeGenerator.loadCodeGenProviders(deploymentClassLoader)).isEmpty()) {
                    return List.of();
                }
                for (CodeGenProvider provider : codeGenProviders) {
                    Path outputDir = CodeGenerator.codeGenOutDir(Path.of(module.getPreBuildOutputDir(), new String[0]), provider, sourcePath -> module.addSourcePathFirst(sourcePath.toAbsolutePath().toString()));
                    for (Path sourceParentDir : module.getSourceParents()) {
                        if (codeGens.isEmpty()) {
                            codeGens = new ArrayList();
                        }
                        codeGens.add(new CodeGenData(provider, outputDir, sourceParentDir.resolve(provider.inputDirectory()), Path.of(module.getTargetDir(), new String[0])));
                    }
                }
            }
            return codeGens;
        });
    }

    private static List<CodeGenProvider> loadCodeGenProviders(ClassLoader deploymentClassLoader) throws CodeGenException {
        Class<?> codeGenProviderClass;
        try {
            codeGenProviderClass = deploymentClassLoader.loadClass(CodeGenProvider.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenException("Failed to load CodeGenProvider class from deployment classloader", (Throwable)e);
        }
        Iterator<?> i = ServiceLoader.load(codeGenProviderClass, deploymentClassLoader).iterator();
        if (!i.hasNext()) {
            return List.of();
        }
        ArrayList<CodeGenProvider> codeGenProviders = new ArrayList<CodeGenProvider>();
        while (i.hasNext()) {
            codeGenProviders.add((CodeGenProvider)i.next());
        }
        return codeGenProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T callWithClassloader(ClassLoader deploymentClassLoader, CodeGenAction<T> supplier) throws CodeGenException {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(deploymentClassLoader);
            T t = supplier.fire();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    public static boolean trigger(ClassLoader deploymentClassLoader, CodeGenData data, ApplicationModel appModel, Config config, boolean test) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            CodeGenProvider provider = data.provider;
            return provider.shouldRun(data.sourceDir, config) && provider.trigger(new CodeGenContext(appModel, data.outPath, data.buildDir, data.sourceDir, data.redirectIO, config, test));
        });
    }

    public static Properties readCurrentConfigValues(ApplicationModel appModel, String launchMode, Properties buildSystemProps, QuarkusClassLoader deploymentClassLoader, Properties originalProperties) {
        Config config = null;
        try {
            config = CodeGenerator.getConfig(appModel, LaunchMode.valueOf((String)launchMode), buildSystemProps, deploymentClassLoader);
        }
        catch (CodeGenException e) {
            throw new RuntimeException("Failed to load application configuration", e);
        }
        ConfigTrackingValueTransformer valueTransformer = ConfigTrackingValueTransformer.newInstance(config);
        Properties currentValues = new Properties(originalProperties.size());
        for (Map.Entry<Object, Object> originalProp : originalProperties.entrySet()) {
            String name = originalProp.getKey().toString();
            ConfigValue currentValue = config.getConfigValue(name);
            String current = valueTransformer.transform(name, currentValue);
            if (!originalProp.getValue().equals(current)) {
                log.info((Object)("Option " + name + " has changed since the last build from " + originalProp.getValue() + " to " + current));
            }
            if (current == null) continue;
            currentValues.put(name, current);
        }
        return currentValues;
    }

    public static Config getConfig(ApplicationModel appModel, LaunchMode launchMode, Properties buildSystemProps, QuarkusClassLoader deploymentClassLoader) throws CodeGenException {
        SmallRyeConfig allConfigServices;
        Map<String, List<String>> unavailableConfigServices = CodeGenerator.getUnavailableConfigServices(appModel.getAppArtifact(), (ClassLoader)deploymentClassLoader);
        if (!unavailableConfigServices.isEmpty()) {
            allConfigServices = new HashMap(unavailableConfigServices.size());
            HashMap<String, byte[]> allowedConfigServices = new HashMap<String, byte[]>(unavailableConfigServices.size());
            HashMap<String, byte[]> bannedConfigServices = new HashMap<String, byte[]>(unavailableConfigServices.size());
            for (Map.Entry<String, List<String>> appModuleServices : unavailableConfigServices.entrySet()) {
                String service = appModuleServices.getKey();
                try {
                    ClassPathUtils.consumeAsPaths((ClassLoader)deploymentClassLoader, (String)service, arg_0 -> CodeGenerator.lambda$getConfig$5((Map)allConfigServices, service, arg_0));
                }
                catch (IOException e) {
                    throw new CodeGenException("Failed to read resources from classpath", (Throwable)e);
                }
                List allServices = allConfigServices.getOrDefault(service, List.of());
                allServices.removeAll((Collection)appModuleServices.getValue());
                if (allServices.isEmpty()) {
                    bannedConfigServices.put(service, new byte[0]);
                    continue;
                }
                StringJoiner joiner = new StringJoiner(System.lineSeparator());
                allServices.forEach(joiner::add);
                allowedConfigServices.put(service, joiner.toString().getBytes());
            }
            QuarkusClassLoader.Builder configClBuilder = QuarkusClassLoader.builder((String)"CodeGenerator Config ClassLoader", (ClassLoader)deploymentClassLoader, (boolean)false);
            if (!allowedConfigServices.isEmpty()) {
                configClBuilder.addElement((ClassPathElement)new MemoryClassPathElement(allowedConfigServices, true));
            }
            if (!bannedConfigServices.isEmpty()) {
                configClBuilder.addBannedElement((ClassPathElement)new MemoryClassPathElement(bannedConfigServices, true));
            }
            deploymentClassLoader = configClBuilder.build();
        }
        try {
            allConfigServices = new BuildTimeConfigurationReader((ClassLoader)deploymentClassLoader).initConfiguration(launchMode, buildSystemProps, appModel.getPlatformProperties());
            return allConfigServices;
        }
        catch (Exception e) {
            throw new CodeGenException("Failed to initialize application configuration", (Throwable)e);
        }
        finally {
            if (!unavailableConfigServices.isEmpty()) {
                deploymentClassLoader.close();
            }
        }
    }

    private static Map<String, List<String>> getUnavailableConfigServices(ResolvedDependency dep, ClassLoader classLoader) throws CodeGenException {
        Map map;
        block8: {
            OpenPathTree openTree = dep.getContentTree().open();
            try {
                map = (Map)openTree.apply(META_INF_SERVICES, visit -> {
                    if (visit == null) {
                        return Map.of();
                    }
                    Map unavailableServices = Map.of();
                    Path servicesDir = visit.getPath();
                    for (String serviceClass : CONFIG_SERVICES) {
                        List<String> implList;
                        Path serviceFile = servicesDir.resolve(serviceClass);
                        if (!Files.exists(serviceFile, new LinkOption[0])) continue;
                        try {
                            implList = Files.readAllLines(serviceFile);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Failed to read " + serviceFile, e);
                        }
                        ArrayList<String> unavailableList = new ArrayList<String>(implList.size());
                        for (String impl : implList) {
                            if (classLoader.getResource(impl.replace('.', '/') + ".class") != null) continue;
                            unavailableList.add(impl);
                        }
                        if (unavailableList.isEmpty()) continue;
                        if (unavailableServices.isEmpty()) {
                            unavailableServices = new HashMap();
                        }
                        unavailableServices.put((CallSite)((Object)(META_INF_SERVICES + serviceClass)), unavailableList);
                    }
                    return unavailableServices;
                });
                if (openTree == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (openTree != null) {
                        try {
                            openTree.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CodeGenException("Failed to read " + dep.getResolvedPaths(), (Throwable)e);
                }
            }
            openTree.close();
        }
        return map;
    }

    private static Path codeGenOutDir(Path generatedSourcesDir, CodeGenProvider provider, Consumer<Path> sourceRegistrar) throws CodeGenException {
        Path outputDir = generatedSourcesDir.resolve(provider.providerId());
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            sourceRegistrar.accept(outputDir);
            return outputDir;
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to create output directory for generated sources: " + outputDir.toAbsolutePath(), (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$getConfig$5(Map allConfigServices, String service, Path p) {
        try {
            allConfigServices.computeIfAbsent(service, k -> new ArrayList()).addAll(Files.readAllLines(p));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + p, e);
        }
    }

    @FunctionalInterface
    private static interface CodeGenAction<T> {
        public T fire() throws CodeGenException;
    }
}

