/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.cache.ConnectionCache;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.agroal.narayana.NarayanaTransactionIntegration;
import io.agroal.pool.DataSource;
import io.quarkus.agroal.runtime.AgroalConnectionConfigurer;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.agroal.runtime.AgroalEventLoggingListener;
import io.quarkus.agroal.runtime.AgroalOpenTelemetryWrapper;
import io.quarkus.agroal.runtime.AgroalVaultCredentialsProviderPassword;
import io.quarkus.agroal.runtime.DataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourceJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourcesJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.JdbcDriver;
import io.quarkus.agroal.runtime.QuarkusNettyConnectionCache;
import io.quarkus.agroal.runtime.QuarkusSimpleConnectionCache;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.agroal.runtime.UnknownDbAgroalConnectionConfigurer;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.narayana.jta.runtime.TransactionManagerConfiguration;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jboss.tm.XAResourceRecoveryRegistry;

@Deprecated(since="3.16", forRemoval=true)
@Singleton
public class DataSources {
    private static final Logger log = Logger.getLogger((String)DataSources.class.getName());
    private final DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig;
    private final DataSourcesRuntimeConfig dataSourcesRuntimeConfig;
    private final DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig;
    private final DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig;
    private final TransactionManagerConfiguration transactionRuntimeConfig;
    private final TransactionManager transactionManager;
    private final XAResourceRecoveryRegistry xaResourceRecoveryRegistry;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final AgroalDataSourceSupport agroalDataSourceSupport;
    private final Instance<AgroalPoolInterceptor> agroalPoolInterceptors;
    private final Instance<AgroalOpenTelemetryWrapper> agroalOpenTelemetryWrapper;

    public DataSources(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig, TransactionManagerConfiguration transactionRuntimeConfig, TransactionManager transactionManager, XAResourceRecoveryRegistry xaResourceRecoveryRegistry, TransactionSynchronizationRegistry transactionSynchronizationRegistry, AgroalDataSourceSupport agroalDataSourceSupport, @Any Instance<AgroalPoolInterceptor> agroalPoolInterceptors, Instance<AgroalOpenTelemetryWrapper> agroalOpenTelemetryWrapper) {
        this.dataSourcesBuildTimeConfig = dataSourcesBuildTimeConfig;
        this.dataSourcesRuntimeConfig = dataSourcesRuntimeConfig;
        this.dataSourcesJdbcBuildTimeConfig = dataSourcesJdbcBuildTimeConfig;
        this.dataSourcesJdbcRuntimeConfig = dataSourcesJdbcRuntimeConfig;
        this.transactionRuntimeConfig = transactionRuntimeConfig;
        this.transactionManager = transactionManager;
        this.xaResourceRecoveryRegistry = xaResourceRecoveryRegistry;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.agroalDataSourceSupport = agroalDataSourceSupport;
        this.agroalPoolInterceptors = agroalPoolInterceptors;
        this.agroalOpenTelemetryWrapper = agroalOpenTelemetryWrapper;
    }

    @Deprecated
    public static AgroalDataSource fromName(String dataSourceName) {
        return (AgroalDataSource)AgroalDataSourceUtil.dataSourceInstance(dataSourceName).get();
    }

    @Deprecated
    public boolean isDataSourceCreated(String dataSourceName) {
        return this.agroalDataSourceSupport.entries.containsKey(dataSourceName);
    }

    @Deprecated
    public Set<String> getActiveDataSourceNames() {
        return AgroalDataSourceUtil.activeDataSourceNames();
    }

    @Deprecated
    public AgroalDataSource getDataSource(String dataSourceName) {
        return (AgroalDataSource)ClientProxy.unwrap((Object)((AgroalDataSource)AgroalDataSourceUtil.dataSourceInstance(dataSourceName).get()));
    }

    public AgroalDataSource createDataSource(String dataSourceName, boolean otelEnabled) {
        Class<?> driver;
        if (!this.agroalDataSourceSupport.entries.containsKey(dataSourceName)) {
            throw new IllegalArgumentException("No datasource named '" + dataSourceName + "' exists");
        }
        DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig = this.dataSourcesJdbcBuildTimeConfig.dataSources().get(dataSourceName).jdbc();
        DataSourceRuntimeConfig dataSourceRuntimeConfig = (DataSourceRuntimeConfig)this.dataSourcesRuntimeConfig.dataSources().get(dataSourceName);
        DataSourceJdbcRuntimeConfig dataSourceJdbcRuntimeConfig = this.dataSourcesJdbcRuntimeConfig.dataSources().get(dataSourceName).jdbc();
        if (!dataSourceJdbcRuntimeConfig.url().isPresent()) {
            throw new IllegalArgumentException("Datasource " + dataSourceName + " does not have a JDBC URL and should not be created");
        }
        DataSources.loadDriversInTCCL();
        AgroalDataSourceSupport.Entry matchingSupportEntry = this.agroalDataSourceSupport.entries.get(dataSourceName);
        String resolvedDriverClass = matchingSupportEntry.resolvedDriverClass;
        try {
            driver = Class.forName(resolvedDriverClass, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load the datasource driver " + resolvedDriverClass + " for datasource " + dataSourceName, e);
        }
        String jdbcUrl = dataSourceJdbcRuntimeConfig.url().get();
        String resolvedDbKind = matchingSupportEntry.resolvedDbKind;
        AgroalConnectionConfigurer agroalConnectionConfigurer = (AgroalConnectionConfigurer)Arc.container().instance(AgroalConnectionConfigurer.class, new Annotation[]{new JdbcDriver.JdbcDriverLiteral(resolvedDbKind)}).orElse((Object)new UnknownDbAgroalConnectionConfigurer());
        AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
        if (!dataSourceJdbcRuntimeConfig.poolingEnabled()) {
            dataSourceConfiguration.dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.AGROAL_POOLLESS);
        }
        AgroalConnectionPoolConfigurationSupplier poolConfiguration = dataSourceConfiguration.connectionPoolConfiguration();
        AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = poolConfiguration.connectionFactoryConfiguration();
        boolean mpMetricsPresent = this.agroalDataSourceSupport.mpMetricsPresent;
        this.applyNewConfiguration(dataSourceName, dataSourceConfiguration, poolConfiguration, connectionFactoryConfiguration, driver, jdbcUrl, dataSourceJdbcBuildTimeConfig, dataSourceRuntimeConfig, dataSourceJdbcRuntimeConfig, this.transactionRuntimeConfig, mpMetricsPresent);
        if (this.agroalDataSourceSupport.disableSslSupport) {
            agroalConnectionConfigurer.disableSslSupport(resolvedDbKind, dataSourceConfiguration, dataSourceJdbcRuntimeConfig.additionalJdbcProperties());
        }
        try {
            Class.forName("io.netty.util.concurrent.FastThreadLocal", true, Thread.currentThread().getContextClassLoader());
            dataSourceConfiguration.connectionPoolConfiguration().connectionCache((ConnectionCache)new QuarkusNettyConnectionCache());
        }
        catch (ClassNotFoundException e) {
            dataSourceConfiguration.connectionPoolConfiguration().connectionCache((ConnectionCache)new QuarkusSimpleConnectionCache());
        }
        agroalConnectionConfigurer.setExceptionSorter(resolvedDbKind, dataSourceConfiguration);
        AgroalDataSourceConfiguration agroalConfiguration = dataSourceConfiguration.get();
        DataSource dataSource = new DataSource(agroalConfiguration, new AgroalDataSourceListener[]{new AgroalEventLoggingListener(dataSourceName, agroalConfiguration.connectionPoolConfiguration().transactionRequirement() == AgroalConnectionPoolConfiguration.TransactionRequirement.WARN)});
        log.debugv("Started datasource {0} connected to {1}", (Object)dataSourceName, (Object)agroalConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl());
        Collection interceptorList = this.agroalPoolInterceptors.select(new Annotation[]{AgroalDataSourceUtil.qualifier(dataSourceName)}).stream().collect(Collectors.toList());
        if (!interceptorList.isEmpty()) {
            dataSource.setPoolInterceptors(interceptorList);
        }
        if (dataSourceJdbcBuildTimeConfig.telemetry() && dataSourceJdbcRuntimeConfig.telemetry().orElse(true).booleanValue() && otelEnabled) {
            dataSource = ((AgroalOpenTelemetryWrapper)this.agroalOpenTelemetryWrapper.get()).apply((AgroalDataSource)dataSource);
        }
        return dataSource;
    }

    private void applyNewConfiguration(String dataSourceName, AgroalDataSourceConfigurationSupplier dataSourceConfiguration, AgroalConnectionPoolConfigurationSupplier poolConfiguration, AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration, Class<?> driver, String jdbcUrl, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceJdbcRuntimeConfig dataSourceJdbcRuntimeConfig, TransactionManagerConfiguration transactionRuntimeConfig, boolean mpMetricsPresent) {
        connectionFactoryConfiguration.jdbcUrl(jdbcUrl);
        connectionFactoryConfiguration.connectionProviderClass(driver);
        connectionFactoryConfiguration.trackJdbcResources(dataSourceJdbcRuntimeConfig.detectStatementLeaks());
        if (dataSourceJdbcRuntimeConfig.transactionIsolationLevel().isPresent()) {
            connectionFactoryConfiguration.jdbcTransactionIsolation(dataSourceJdbcRuntimeConfig.transactionIsolationLevel().get());
        }
        if (dataSourceJdbcBuildTimeConfig.transactions() != TransactionIntegration.DISABLED) {
            NarayanaTransactionIntegration txIntegration = new NarayanaTransactionIntegration(this.transactionManager, this.transactionSynchronizationRegistry, null, false, dataSourceJdbcBuildTimeConfig.transactions() == TransactionIntegration.XA && transactionRuntimeConfig.enableRecovery() ? this.xaResourceRecoveryRegistry : null);
            if (dataSourceJdbcBuildTimeConfig.transactions() == TransactionIntegration.XA && !transactionRuntimeConfig.enableRecovery()) {
                log.warnv("Datasource {0} enables XA but transaction recovery is not enabled. Please enable transaction recovery by setting quarkus.transaction-manager.enable-recovery=true, otherwise data may be lost if the application is terminated abruptly", (Object)dataSourceName);
            }
            poolConfiguration.transactionIntegration((io.agroal.api.transaction.TransactionIntegration)txIntegration);
        }
        if (dataSourceJdbcRuntimeConfig.newConnectionSql().isPresent()) {
            connectionFactoryConfiguration.initialSql(dataSourceJdbcRuntimeConfig.newConnectionSql().get());
        }
        if (dataSourceJdbcBuildTimeConfig.enableMetrics().isPresent()) {
            dataSourceConfiguration.metricsEnabled(dataSourceJdbcBuildTimeConfig.enableMetrics().get().booleanValue());
        } else {
            dataSourceConfiguration.metricsEnabled(this.dataSourcesBuildTimeConfig.metricsEnabled() && mpMetricsPresent);
        }
        if (dataSourceRuntimeConfig.username().isPresent()) {
            NamePrincipal username = new NamePrincipal((String)dataSourceRuntimeConfig.username().get());
            connectionFactoryConfiguration.principal((Principal)username).recoveryPrincipal((Principal)username);
        }
        if (dataSourceRuntimeConfig.password().isPresent()) {
            SimplePassword password = new SimplePassword((String)dataSourceRuntimeConfig.password().get());
            connectionFactoryConfiguration.credential((Object)password).recoveryCredential((Object)password);
        }
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            connectionFactoryConfiguration.credential((Object)new AgroalVaultCredentialsProviderPassword(name, credentialsProvider));
        }
        for (Map.Entry entry : dataSourceJdbcRuntimeConfig.additionalJdbcProperties().entrySet()) {
            connectionFactoryConfiguration.jdbcProperty((String)entry.getKey(), (String)entry.getValue());
        }
        poolConfiguration.minSize(dataSourceJdbcRuntimeConfig.minSize());
        poolConfiguration.maxSize(dataSourceJdbcRuntimeConfig.maxSize());
        if (dataSourceJdbcRuntimeConfig.initialSize().isPresent() && dataSourceJdbcRuntimeConfig.initialSize().getAsInt() > 0) {
            poolConfiguration.initialSize(dataSourceJdbcRuntimeConfig.initialSize().getAsInt());
        }
        poolConfiguration.connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator());
        if (dataSourceJdbcRuntimeConfig.acquisitionTimeout().isPresent()) {
            poolConfiguration.acquisitionTimeout(dataSourceJdbcRuntimeConfig.acquisitionTimeout().get());
        }
        poolConfiguration.validationTimeout(dataSourceJdbcRuntimeConfig.backgroundValidationInterval());
        if (dataSourceJdbcRuntimeConfig.foregroundValidationInterval().isPresent()) {
            poolConfiguration.idleValidationTimeout(dataSourceJdbcRuntimeConfig.foregroundValidationInterval().get());
        }
        if (dataSourceJdbcRuntimeConfig.validationQuerySql().isPresent()) {
            final String validationQuery = dataSourceJdbcRuntimeConfig.validationQuerySql().get();
            poolConfiguration.connectionValidator(new AgroalConnectionPoolConfiguration.ConnectionValidator(){

                public boolean isValid(Connection connection) {
                    boolean bl;
                    block8: {
                        Statement stmt = connection.createStatement();
                        try {
                            stmt.execute(validationQuery);
                            bl = true;
                            if (stmt == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                log.warn((Object)"Connection validation failed", (Throwable)e);
                                return false;
                            }
                        }
                        stmt.close();
                    }
                    return bl;
                }
            });
        }
        poolConfiguration.validateOnBorrow(dataSourceJdbcRuntimeConfig.validateOnBorrow());
        poolConfiguration.reapTimeout(dataSourceJdbcRuntimeConfig.idleRemovalInterval());
        if (dataSourceJdbcRuntimeConfig.leakDetectionInterval().isPresent()) {
            poolConfiguration.leakTimeout(dataSourceJdbcRuntimeConfig.leakDetectionInterval().get());
        }
        if (dataSourceJdbcRuntimeConfig.maxLifetime().isPresent()) {
            poolConfiguration.maxLifetime(dataSourceJdbcRuntimeConfig.maxLifetime().get());
        }
        if (dataSourceJdbcRuntimeConfig.transactionRequirement().isPresent()) {
            poolConfiguration.transactionRequirement(dataSourceJdbcRuntimeConfig.transactionRequirement().get());
        }
        poolConfiguration.enhancedLeakReport(dataSourceJdbcRuntimeConfig.extendedLeakReport());
        poolConfiguration.flushOnClose(dataSourceJdbcRuntimeConfig.flushOnClose());
    }

    private static void loadDriversInTCCL() {
        ServiceLoader<Driver> drivers = ServiceLoader.load(Driver.class);
        Iterator<Driver> iterator = drivers.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next();
            }
            catch (Throwable throwable) {}
        }
    }
}

