/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.ArrayDeref;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.function.BiFunction;

final class ArrayLoadViaHandle
extends Item {
    private final ArrayDeref arrayDeref;
    private final MemoryOrder mode;

    ArrayLoadViaHandle(ArrayDeref arrayDeref, MemoryOrder mode) {
        this.arrayDeref = arrayDeref;
        this.mode = mode;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return ConstImpl.ofArrayVarHandle(this.arrayDeref.array().type()).process(this.arrayDeref.array().process(this.arrayDeref.index().process(node.prev(), op), op), op);
    }

    @Override
    protected void computeType() {
        this.initType(this.arrayDeref.type());
        if (this.arrayDeref.hasGenericType()) {
            this.initGenericType(this.arrayDeref.genericType());
        }
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Plain -> "get";
            case MemoryOrder.Opaque -> "getOpaque";
            case MemoryOrder.Acquire -> "getAcquire";
            case MemoryOrder.Volatile -> "getVolatile";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, MethodTypeDesc.of(this.type(), this.arrayDeref.array().type(), ConstantDescs.CD_int));
    }
}

