/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;

public class SseMcpConnection
extends McpConnectionBase {
    private final HttpServerResponse response;

    SseMcpConnection(String id, McpServerRuntimeConfig serverConfig, HttpServerResponse response) {
        super(id, serverConfig);
        this.response = response;
    }

    public Future<Void> sendEvent(String name, String data) {
        return this.response.write("event: " + name + "\ndata: " + data + "\n\n");
    }

    public Future<Void> send(JsonObject message) {
        if (message == null) {
            return Future.succeededFuture();
        }
        if (this.trafficLogger != null) {
            this.trafficLogger.messageSent(message, (McpConnection)this);
        }
        return this.sendEvent("message", message.encode());
    }
}

