/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.services;

import dev.langchain4j.Experimental;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsRequest;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsResponse;
import io.quarkiverse.langchain4j.watsonx.client.UtilityAgentToolsRestApi;
import io.quarkiverse.langchain4j.watsonx.exception.BuiltinServiceException;
import java.util.Objects;
import java.util.concurrent.Callable;

@Experimental
public class WeatherService {
    private static final String NO_CITY_FOUND = "Unable to find coordinates of the location:";
    private UtilityAgentToolsRestApi client;

    public WeatherService(UtilityAgentToolsRestApi utilityAgentToolRestApi) {
        this.client = utilityAgentToolRestApi;
    }

    public String find(String name, String country) throws WeatherServiceException, NoCityFoundException {
        if (Objects.isNull(name) || name.isBlank()) {
            throw new IllegalArgumentException("The field \"name\" cannot be null or empty");
        }
        final UtilityAgentToolsRequest request = new UtilityAgentToolsRequest(UtilityAgentToolsRequest.ToolName.WEATHER, new UtilityAgentToolsRequest.WeatherInput(name, country));
        try {
            UtilityAgentToolsResponse response = WatsonxUtils.retryOn(new Callable<UtilityAgentToolsResponse>(){
                final /* synthetic */ WeatherService this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public UtilityAgentToolsResponse call() throws Exception {
                    return this.this$0.client.run(request);
                }
            });
            return response.output();
        }
        catch (BuiltinServiceException exception) {
            if (Objects.isNull(exception.details())) {
                throw new WeatherServiceException(exception.getMessage(), exception);
            }
            if (exception.details().startsWith(NO_CITY_FOUND)) {
                throw new NoCityFoundException(name, country, exception);
            }
            throw new WeatherServiceException(exception.getMessage(), exception);
        }
    }

    public static class WeatherServiceException
    extends Exception {
        public WeatherServiceException(String message, Throwable e) {
            super(message);
        }
    }

    public static class NoCityFoundException
    extends WeatherServiceException {
        public NoCityFoundException(String city, String country, Throwable e) {
            super("%s %s%s".formatted(WeatherService.NO_CITY_FOUND, city, Objects.isNull(country) ? "" : "," + country), e);
        }
    }
}

