/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.Experimental;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.GoogleSearchResult;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsRequest;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsResponse;
import io.quarkiverse.langchain4j.watsonx.client.UtilityAgentToolsRestApi;
import io.quarkiverse.langchain4j.watsonx.exception.BuiltinServiceException;
import io.quarkiverse.langchain4j.watsonx.runtime.config.BuiltinServiceConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;

@Experimental
public class GoogleSearchService {
    private static final Logger logger = Logger.getLogger(GoogleSearchService.class);
    private static final ObjectMapper objectMapper = QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER;
    private UtilityAgentToolsRestApi client;
    private int maxResults;

    public GoogleSearchService(UtilityAgentToolsRestApi utilityAgentToolRestApi, BuiltinServiceConfig.GoogleSearchConfig config) {
        this.client = utilityAgentToolRestApi;
        this.maxResults = config.maxResults();
    }

    public List<GoogleSearchResult> search(String input) throws BuiltinServiceException {
        return this.search(input, this.maxResults);
    }

    public List<GoogleSearchResult> search(String input, Integer maxResults) throws BuiltinServiceException {
        if (Objects.isNull(input) || input.isBlank()) {
            throw new IllegalArgumentException("The field \"input\" cannot be null or empty");
        }
        if (maxResults == null || maxResults < 0) {
            maxResults = this.maxResults;
        }
        if (maxResults > 20) {
            logger.info((Object)"The tool cannot return more than 20 elements, set maxResults to 20");
            maxResults = 20;
        }
        final UtilityAgentToolsRequest request = new UtilityAgentToolsRequest(UtilityAgentToolsRequest.ToolName.GOOGLE_SEARCH, new UtilityAgentToolsRequest.GoogleSearchInput(input), Map.of("maxResults", maxResults));
        UtilityAgentToolsResponse response = WatsonxUtils.retryOn(new Callable<UtilityAgentToolsResponse>(){
            final /* synthetic */ GoogleSearchService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public UtilityAgentToolsResponse call() throws Exception {
                return this.this$0.client.run(request);
            }
        });
        try {
            return (List)objectMapper.readValue(response.output(), (TypeReference)new TypeReference<List<GoogleSearchResult>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

