/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.runtime;

import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkiverse.langchain4j.watsonx.client.UtilityAgentToolsRestApi;
import io.quarkiverse.langchain4j.watsonx.client.WatsonxClientLogger;
import io.quarkiverse.langchain4j.watsonx.client.filter.BearerTokenHeaderFactory;
import io.quarkiverse.langchain4j.watsonx.runtime.TokenGenerationCache;
import io.quarkiverse.langchain4j.watsonx.runtime.config.BuiltinServiceConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.IAMConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.LangChain4jWatsonxConfig;
import io.quarkiverse.langchain4j.watsonx.services.GoogleSearchService;
import io.quarkiverse.langchain4j.watsonx.services.WeatherService;
import io.quarkiverse.langchain4j.watsonx.services.WebCrawlerService;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

@Recorder
public class BuiltinServiceRecorder {
    private static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];
    private static final String MISSING_BUILTIN_SERVICE_PROPERTY_ERROR = "To use the built-in service classes, you must set the property 'quarkus.langchain4j.watsonx.built-in.%s'";
    private static final String INVALID_BASE_URL_ERROR = "The property 'quarkus.langchain4j.watsonx.base-url' does not have a correct url. Use one of the urls given in the documentation or use the property 'quarkus.langchain4j.watsonx.built-in-service.base-url' to set a custom url.";
    private final RuntimeValue<LangChain4jWatsonxConfig> runtimeConfig;

    public BuiltinServiceRecorder(RuntimeValue<LangChain4jWatsonxConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Supplier<WebCrawlerService> webCrawler() {
        final IAMConfig iamConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().iam();
        BuiltinServiceConfig builtinToolConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).builtInService();
        final String baseUrl = (String)OptionalUtil.firstOrDefault((Object)this.getWxBaseUrl(((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl()), (Optional[])new Optional[]{builtinToolConfig.baseUrl()});
        if (Objects.isNull(baseUrl) && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl().isPresent()) {
            throw new RuntimeException(INVALID_BASE_URL_ERROR);
        }
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{builtinToolConfig.apiKey()});
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(baseUrl, apiKey);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        final Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{builtinToolConfig.timeout(), ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().timeout()});
        final boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().logRequests().orElse(false), (Optional[])new Optional[]{builtinToolConfig.logRequests()});
        final boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().logResponses().orElse(false), (Optional[])new Optional[]{builtinToolConfig.logResponses()});
        return new Supplier<WebCrawlerService>(){
            final /* synthetic */ BuiltinServiceRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WebCrawlerService get() {
                return new WebCrawlerService(this.this$0.createRestClient(baseUrl, apiKey, iamConfig, timeout, logRequests, logResponses));
            }
        };
    }

    public Supplier<GoogleSearchService> googleSearch() {
        final IAMConfig iamConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().iam();
        final BuiltinServiceConfig builtinToolConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).builtInService();
        final String baseUrl = (String)OptionalUtil.firstOrDefault((Object)this.getWxBaseUrl(((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl()), (Optional[])new Optional[]{builtinToolConfig.baseUrl()});
        if (Objects.isNull(baseUrl) && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl().isPresent()) {
            throw new RuntimeException(INVALID_BASE_URL_ERROR);
        }
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{builtinToolConfig.apiKey()});
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(baseUrl, apiKey);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        final Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{builtinToolConfig.timeout(), ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().timeout()});
        final boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().logRequests().orElse(false), (Optional[])new Optional[]{builtinToolConfig.logRequests()});
        final boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().logResponses().orElse(false), (Optional[])new Optional[]{builtinToolConfig.logResponses()});
        return new Supplier<GoogleSearchService>(){
            final /* synthetic */ BuiltinServiceRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public GoogleSearchService get() {
                return new GoogleSearchService(this.this$0.createRestClient(baseUrl, apiKey, iamConfig, timeout, logRequests, logResponses), builtinToolConfig.googleSearch());
            }
        };
    }

    public Supplier<WeatherService> weather() {
        final IAMConfig iamConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().iam();
        BuiltinServiceConfig builtinToolConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).builtInService();
        final String baseUrl = (String)OptionalUtil.firstOrDefault((Object)this.getWxBaseUrl(((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl()), (Optional[])new Optional[]{builtinToolConfig.baseUrl()});
        if (Objects.isNull(baseUrl) && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl().isPresent()) {
            throw new RuntimeException(INVALID_BASE_URL_ERROR);
        }
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{builtinToolConfig.apiKey()});
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(baseUrl, apiKey);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        final Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{builtinToolConfig.timeout(), ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().timeout()});
        final boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().logRequests().orElse(false), (Optional[])new Optional[]{builtinToolConfig.logRequests()});
        final boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().logResponses().orElse(false), (Optional[])new Optional[]{builtinToolConfig.logResponses()});
        return new Supplier<WeatherService>(){
            final /* synthetic */ BuiltinServiceRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WeatherService get() {
                return new WeatherService(this.this$0.createRestClient(baseUrl, apiKey, iamConfig, timeout, logRequests, logResponses));
            }
        };
    }

    private UtilityAgentToolsRestApi createRestClient(String baseUrl, String apiKey, IAMConfig iamConfig, Duration timeout, boolean logRequests, boolean logResponses) {
        QuarkusRestClientBuilder builder = QuarkusRestClientBuilder.newBuilder().baseUri(URI.create(baseUrl)).clientHeadersFactory((ClientHeadersFactory)new BearerTokenHeaderFactory(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamConfig.baseUrl(), iamConfig.grantType(), iamConfig.timeout().orElse(Duration.ofSeconds(10L))))).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).connectTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        if (logRequests || logResponses) {
            builder.loggingScope(LoggingScope.REQUEST_RESPONSE).clientLogger((ClientLogger)new WatsonxClientLogger(logRequests, logResponses));
        }
        return (UtilityAgentToolsRestApi)builder.build(UtilityAgentToolsRestApi.class);
    }

    private String getWxBaseUrl(Optional<String> baseUrl) {
        if (baseUrl.isEmpty()) {
            return null;
        }
        return switch (baseUrl.get()) {
            case "https://us-south.ml.cloud.ibm.com" -> "https://api.dataplatform.cloud.ibm.com/wx";
            case "https://eu-de.ml.cloud.ibm.com" -> "https://api.eu-de.dataplatform.cloud.ibm.com/wx";
            case "https://eu-gb.ml.cloud.ibm.com" -> "https://api.eu-gb.dataplatform.cloud.ibm.com/wx";
            case "https://jp-tok.ml.cloud.ibm.com" -> "https://api.jp-tok.dataplatform.cloud.ibm.com/wx";
            case "https://au-syd.ml.cloud.ibm.com" -> "https://api.au-syd.dai.cloud.ibm.com/wx";
            case "https://ca-tor.ml.cloud.ibm.com" -> "https://api.ca-tor.dai.cloud.ibm.com/wx";
            default -> null;
        };
    }

    private List<ConfigValidationException.Problem> checkConfigurations(String baseUrl, String apiKey) {
        ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
        if (Objects.isNull(baseUrl)) {
            configProblems.add(new ConfigValidationException.Problem(MISSING_BUILTIN_SERVICE_PROPERTY_ERROR.formatted("base-url")));
        }
        if (Objects.isNull(apiKey)) {
            configProblems.add(new ConfigValidationException.Problem(MISSING_BUILTIN_SERVICE_PROPERTY_ERROR.formatted("api-key")));
        }
        return configProblems;
    }
}

