/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.watsonx.Watsonx;
import io.quarkiverse.langchain4j.watsonx.WatsonxChatRequestParameters;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.TextChatMessage;
import io.quarkiverse.langchain4j.watsonx.bean.TextChatParameters;
import io.quarkiverse.langchain4j.watsonx.bean.TextChatRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextStreamingChatResponse;
import io.smallrye.mutiny.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class WatsonxStreamingChatModel
extends Watsonx
implements StreamingChatModel {
    private static final String ID_CONTEXT = "ID";
    private static final String MODEL_ID_CONTEXT = "MODEL_ID";
    private static final String USAGE_CONTEXT = "USAGE";
    private static final String FINISH_REASON_CONTEXT = "FINISH_REASON";
    private static final String ROLE_CONTEXT = "ROLE";
    private static final String TOOLS_CONTEXT = "TOOLS";
    private static final String COMPLETE_MESSAGE_CONTEXT = "COMPLETE_MESSAGE";
    private final WatsonxChatRequestParameters defaultRequestParameters;

    public WatsonxStreamingChatModel(Builder builder) {
        super(builder);
        ResponseFormat responseFormat = Objects.nonNull(builder.responseFormatText) && (builder.responseFormatText.equals("json_object") || builder.responseFormatText.equals("json_schema")) ? ResponseFormat.JSON : null;
        this.defaultRequestParameters = ((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)((WatsonxChatRequestParameters.Builder)WatsonxChatRequestParameters.builder().modelName(builder.modelId)).toolChoice(builder.toolChoice)).toolChoiceName(builder.toolChoiceName).frequencyPenalty(builder.frequencyPenalty)).logprobs(builder.logprobs).topLogprobs(builder.topLogprobs).maxOutputTokens(builder.maxTokens)).n(builder.n).presencePenalty(builder.presencePenalty)).responseFormat(builder.responseFormat)).seed(builder.seed).stopSequences(builder.stop)).temperature(builder.temperature)).topP(builder.topP)).timeLimit(builder.timeout).responseFormat(responseFormat)).build();
    }

    public void doChat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        String modelId = chatRequest.parameters().modelName();
        ChatRequestParameters parameters = chatRequest.parameters();
        List toolSpecifications = chatRequest.parameters().toolSpecifications();
        if (parameters.topK() != null) {
            throw new UnsupportedFeatureException("'topK' parameter is not supported.");
        }
        List<TextChatMessage> messages = chatRequest.messages().stream().map(TextChatMessage::convert).toList();
        List<TextChatMessage.TextChatParameterTool> tools = toolSpecifications != null && toolSpecifications.size() > 0 ? toolSpecifications.stream().map(TextChatMessage.TextChatParameterTool::of).toList() : null;
        TextChatParameters textChatParameters = TextChatParameters.convert(parameters);
        final Context context = Context.empty();
        if (Objects.nonNull(parameters.toolChoice()) && parameters.toolChoice().equals((Object)ToolChoice.REQUIRED)) {
            context.put(FINISH_REASON_CONTEXT, (Object)"tool_calls");
        }
        TextChatRequest request = new TextChatRequest(modelId, this.spaceId, this.projectId, messages, tools, textChatParameters);
        context.put(TOOLS_CONTEXT, new ArrayList());
        context.put(COMPLETE_MESSAGE_CONTEXT, (Object)new StringBuilder());
        this.client.streamingChat(request, this.version).onFailure(WatsonxUtils::isTokenExpired).retry().atMost(1L).subscribe().with(context, (Consumer)new Consumer<TextStreamingChatResponse>(){
            final /* synthetic */ WatsonxStreamingChatModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(TextStreamingChatResponse chunk) {
                try {
                    if (chunk.choices().size() == 0) {
                        context.put(WatsonxStreamingChatModel.USAGE_CONTEXT, (Object)chunk.usage());
                        return;
                    }
                    TextStreamingChatResponse.TextChatResultChoice message = chunk.choices().get(0);
                    if (!context.contains(WatsonxStreamingChatModel.ID_CONTEXT) && chunk.id() != null) {
                        context.put(WatsonxStreamingChatModel.ID_CONTEXT, (Object)chunk.id());
                    }
                    if (!context.contains(WatsonxStreamingChatModel.MODEL_ID_CONTEXT) && chunk.modelId() != null) {
                        context.put(WatsonxStreamingChatModel.MODEL_ID_CONTEXT, (Object)chunk.modelId());
                    }
                    if (message.finishReason() != null && !context.contains(WatsonxStreamingChatModel.FINISH_REASON_CONTEXT)) {
                        context.put(WatsonxStreamingChatModel.FINISH_REASON_CONTEXT, (Object)message.finishReason());
                    }
                    if (message.delta().role() != null) {
                        context.put(WatsonxStreamingChatModel.ROLE_CONTEXT, (Object)message.delta().role());
                    }
                    if (message.delta().toolCalls() != null) {
                        TextChatMessage.StreamingToolFetcher toolFetcher;
                        TextChatMessage.TextChatToolCall deltaTool = message.delta().toolCalls().get(0);
                        Integer index = deltaTool.index();
                        List tools = (List)context.get(WatsonxStreamingChatModel.TOOLS_CONTEXT);
                        if (index + 1 > tools.size()) {
                            toolFetcher = new TextChatMessage.StreamingToolFetcher(index);
                            tools.add(toolFetcher);
                        } else {
                            toolFetcher = (TextChatMessage.StreamingToolFetcher)tools.get(index);
                        }
                        toolFetcher.setId(deltaTool.id());
                        toolFetcher.setType(deltaTool.type());
                        if (deltaTool.function() != null) {
                            toolFetcher.setName(deltaTool.function().name());
                            toolFetcher.appendArguments(deltaTool.function().arguments());
                        }
                    }
                    if (message.delta().content() != null) {
                        StringBuilder stringBuilder = (StringBuilder)context.get(WatsonxStreamingChatModel.COMPLETE_MESSAGE_CONTEXT);
                        String token = message.delta().content();
                        if (token.isEmpty()) {
                            return;
                        }
                        stringBuilder.append(token);
                        handler.onPartialResponse(token);
                    }
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){
            final /* synthetic */ WatsonxStreamingChatModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(Throwable error) {
                handler.onError(error);
            }
        }, new Runnable(){
            final /* synthetic */ WatsonxStreamingChatModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String id = (String)context.get(WatsonxStreamingChatModel.ID_CONTEXT);
                String modelId = (String)context.get(WatsonxStreamingChatModel.MODEL_ID_CONTEXT);
                String finishReason = (String)context.get(WatsonxStreamingChatModel.FINISH_REASON_CONTEXT);
                TextStreamingChatResponse.TextChatUsage textChatUsage = (TextStreamingChatResponse.TextChatUsage)context.get(WatsonxStreamingChatModel.USAGE_CONTEXT);
                TokenUsage tokenUsage = textChatUsage.toTokenUsage();
                ChatResponse.Builder chatResponse = ChatResponse.builder().metadata(ChatResponseMetadata.builder().id(id).modelName(modelId).tokenUsage(tokenUsage).finishReason(this.this$0.toFinishReason(finishReason)).build());
                if (finishReason.equals("tool_calls")) {
                    List tools = (List)context.get(WatsonxStreamingChatModel.TOOLS_CONTEXT);
                    List<ToolExecutionRequest> toolExecutionRequests = tools.stream().map(TextChatMessage.StreamingToolFetcher::build).map(TextChatMessage.TextChatToolCall::convert).toList();
                    handler.onCompleteResponse(chatResponse.aiMessage(AiMessage.from(toolExecutionRequests)).build());
                } else {
                    StringBuilder message = (StringBuilder)context.get(WatsonxStreamingChatModel.COMPLETE_MESSAGE_CONTEXT);
                    AiMessage aiMessage = AiMessage.from((String)message.toString());
                    handler.onCompleteResponse(chatResponse.aiMessage(aiMessage).build());
                }
            }
        });
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public Set<Capability> supportedCapabilities() {
        if (Objects.nonNull(this.responseFormatText) && this.responseFormatText.equals("json_schema")) {
            return Set.of(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return Set.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    private FinishReason toFinishReason(String reason) {
        if (reason == null) {
            return FinishReason.OTHER;
        }
        return switch (reason) {
            case "length" -> FinishReason.LENGTH;
            case "stop" -> FinishReason.STOP;
            case "tool_calls" -> FinishReason.TOOL_EXECUTION;
            case "time_limit", "cancelled", "error" -> FinishReason.OTHER;
            default -> throw new IllegalArgumentException("%s not supported".formatted(reason));
        };
    }

    public static final class Builder
    extends Watsonx.Builder<Builder> {
        private ToolChoice toolChoice;
        private String toolChoiceName;
        private Double frequencyPenalty;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer maxTokens;
        private Integer n;
        private Double presencePenalty;
        private ResponseFormat responseFormat;
        private Integer seed;
        private List<String> stop;
        private Double temperature;
        private Double topP;

        public Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder toolChoiceName(String toolChoiceName) {
            this.toolChoiceName = toolChoiceName;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public WatsonxStreamingChatModel build() {
            return new WatsonxStreamingChatModel(this);
        }
    }
}

