/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationParameters;
import java.time.Duration;

public class WatsonxGenerationRequestParameters
extends DefaultChatRequestParameters {
    private String decodingMethod;
    private TextGenerationParameters.LengthPenalty lengthPenalty;
    private Integer minNewTokens;
    private Integer randomSeed;
    private Duration timeLimit;
    private Double repetitionPenalty;
    private Integer truncateInputTokens;
    private Boolean includeStopSequence;

    private WatsonxGenerationRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.decodingMethod = builder.decodingMethod;
        this.lengthPenalty = builder.lengthPenalty;
        this.minNewTokens = builder.minNewTokens;
        this.randomSeed = builder.randomSeed;
        this.timeLimit = builder.timeLimit;
        this.repetitionPenalty = builder.repetitionPenalty;
        this.truncateInputTokens = builder.truncateInputTokens;
        this.includeStopSequence = builder.includeStopSequence;
    }

    public String decodingMethod() {
        return this.decodingMethod;
    }

    public TextGenerationParameters.LengthPenalty lengthPenalty() {
        return this.lengthPenalty;
    }

    public Integer minNewTokens() {
        return this.minNewTokens;
    }

    public Integer randomSeed() {
        return this.randomSeed;
    }

    public Duration timeLimit() {
        return this.timeLimit;
    }

    public Double repetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Integer truncateInputTokens() {
        return this.truncateInputTokens;
    }

    public Boolean includeStopSequence() {
        return this.includeStopSequence;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatRequestParameters overrideWith(ChatRequestParameters that) {
        return WatsonxGenerationRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private String decodingMethod;
        private TextGenerationParameters.LengthPenalty lengthPenalty;
        private Integer minNewTokens;
        private Integer randomSeed;
        private Duration timeLimit;
        private Double repetitionPenalty;
        private Integer truncateInputTokens;
        private Boolean includeStopSequence;

        public Builder overrideWith(ChatRequestParameters parameters) {
            parameters = parameters == null ? WatsonxGenerationRequestParameters.builder().build() : parameters;
            super.overrideWith(parameters);
            if (parameters instanceof WatsonxGenerationRequestParameters) {
                WatsonxGenerationRequestParameters watsonxParameters = (WatsonxGenerationRequestParameters)parameters;
                this.decodingMethod((String)Utils.getOrDefault((Object)watsonxParameters.decodingMethod(), (Object)this.decodingMethod));
                this.lengthPenalty((TextGenerationParameters.LengthPenalty)Utils.getOrDefault((Object)watsonxParameters.lengthPenalty(), (Object)this.lengthPenalty));
                this.minNewTokens((Integer)Utils.getOrDefault((Object)watsonxParameters.minNewTokens(), (Object)this.minNewTokens));
                this.randomSeed((Integer)Utils.getOrDefault((Object)watsonxParameters.randomSeed(), (Object)this.randomSeed));
                this.timeLimit((Duration)Utils.getOrDefault((Object)watsonxParameters.timeLimit(), (Object)this.timeLimit));
                this.repetitionPenalty((Double)Utils.getOrDefault((Object)watsonxParameters.repetitionPenalty(), (Object)this.repetitionPenalty));
                this.truncateInputTokens((Integer)Utils.getOrDefault((Object)watsonxParameters.truncateInputTokens(), (Object)this.truncateInputTokens));
                this.includeStopSequence((Boolean)Utils.getOrDefault((Object)watsonxParameters.includeStopSequence(), (Object)this.includeStopSequence));
            }
            return this;
        }

        public Builder decodingMethod(String decodingMethod) {
            this.decodingMethod = decodingMethod;
            return this;
        }

        public Builder lengthPenalty(TextGenerationParameters.LengthPenalty lengthPenalty) {
            this.lengthPenalty = lengthPenalty;
            return this;
        }

        public Builder minNewTokens(Integer minNewTokens) {
            this.minNewTokens = minNewTokens;
            return this;
        }

        public Builder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public Builder timeLimit(Duration timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public Builder repetitionPenalty(Double repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder truncateInputTokens(Integer truncateInputTokens) {
            this.truncateInputTokens = truncateInputTokens;
            return this;
        }

        public Builder includeStopSequence(Boolean includeStopSequence) {
            this.includeStopSequence = includeStopSequence;
            return this;
        }

        public WatsonxGenerationRequestParameters build() {
            return new WatsonxGenerationRequestParameters(this);
        }
    }
}

