/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime.gemini;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.VertexAiGeminiChatLanguageModel;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.VertexAiGeminiEmbeddingModel;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.VertexAiGeminiStreamingChatLanguageModel;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.config.ChatModelConfig;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.config.LangChain4jVertexAiGeminiConfig;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.config.LangChain4jVertexAiGeminiEmbeddingConfig;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Recorder
public class VertexAiGeminiRecorder {
    private static final String DUMMY_KEY = "dummy";
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};
    private final RuntimeValue<LangChain4jVertexAiGeminiConfig> runtimeConfig;

    public VertexAiGeminiRecorder(RuntimeValue<LangChain4jVertexAiGeminiConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Supplier<EmbeddingModel> embeddingModel(String configName) {
        LangChain4jVertexAiGeminiConfig.VertexAiGeminiConfig vertexAiConfig = this.correspondingVertexAiConfig(configName);
        if (vertexAiConfig.enableIntegration().booleanValue()) {
            LangChain4jVertexAiGeminiEmbeddingConfig embeddingModelConfig = vertexAiConfig.embeddingModel();
            Optional<String> baseUrl = vertexAiConfig.baseUrl();
            String location = vertexAiConfig.location();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(location)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("location", configName));
            }
            String projectId = vertexAiConfig.projectId();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(projectId)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("project-id", configName));
            }
            VertexAiGeminiEmbeddingModel.Builder builder = VertexAiGeminiEmbeddingModel.builder().baseUrl(baseUrl).location(location).projectId(projectId).publisher(vertexAiConfig.publisher()).modelId(embeddingModelConfig.modelId()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), vertexAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), vertexAiConfig.logResponses()}));
            vertexAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(vertexAiConfig.proxyType()), new InetSocketAddress((String)host, (int)vertexAiConfig.proxyPort()))));
            if (embeddingModelConfig.outputDimension().isPresent()) {
                builder.dimension(embeddingModelConfig.outputDimension().get());
            }
            if (embeddingModelConfig.taskType().isPresent()) {
                builder.taskType(embeddingModelConfig.taskType().get());
            }
            return builder::build;
        }
        return DisabledEmbeddingModel::new;
    }

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> chatModel(String configName) {
        LangChain4jVertexAiGeminiConfig.VertexAiGeminiConfig vertexAiConfig = this.correspondingVertexAiConfig(configName);
        if (vertexAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = vertexAiConfig.chatModel();
            Optional<String> baseUrl = vertexAiConfig.baseUrl();
            String location = vertexAiConfig.location();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(location)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("location", configName));
            }
            String projectId = vertexAiConfig.projectId();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(projectId)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("project-id", configName));
            }
            final VertexAiGeminiChatLanguageModel.Builder builder = VertexAiGeminiChatLanguageModel.builder().baseUrl(baseUrl).location(location).projectId(projectId).publisher(vertexAiConfig.publisher()).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), vertexAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), vertexAiConfig.logResponses()}));
            vertexAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(vertexAiConfig.proxyType()), new InetSocketAddress((String)host, (int)vertexAiConfig.proxyPort()))));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(chatModelConfig.temperature().getAsDouble());
            }
            if (chatModelConfig.topK().isPresent()) {
                builder.topK(chatModelConfig.topK().getAsInt());
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(chatModelConfig.topP().getAsDouble());
            }
            if (chatModelConfig.timeout().isPresent()) {
                builder.timeout(chatModelConfig.timeout().get());
            }
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ VertexAiGeminiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> streamingChatModel(String configName) {
        LangChain4jVertexAiGeminiConfig.VertexAiGeminiConfig vertexAiConfig = this.correspondingVertexAiConfig(configName);
        if (vertexAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = vertexAiConfig.chatModel();
            Optional<String> baseUrl = vertexAiConfig.baseUrl();
            String location = vertexAiConfig.location();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(location)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("location", configName));
            }
            String projectId = vertexAiConfig.projectId();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(projectId)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("project-id", configName));
            }
            final VertexAiGeminiStreamingChatLanguageModel.Builder builder = VertexAiGeminiStreamingChatLanguageModel.builder().baseUrl(baseUrl).location(location).projectId(projectId).publisher(vertexAiConfig.publisher()).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), vertexAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), vertexAiConfig.logResponses()}));
            vertexAiConfig.proxyHost().ifPresent(host -> builder.proxy(new Proxy(Proxy.Type.valueOf(vertexAiConfig.proxyType()), new InetSocketAddress((String)host, (int)vertexAiConfig.proxyPort()))));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(chatModelConfig.temperature().getAsDouble());
            }
            if (chatModelConfig.topK().isPresent()) {
                builder.topK(chatModelConfig.topK().getAsInt());
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(chatModelConfig.topP().getAsDouble());
            }
            if (chatModelConfig.timeout().isPresent()) {
                builder.timeout(chatModelConfig.timeout().get());
            }
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ VertexAiGeminiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    private LangChain4jVertexAiGeminiConfig.VertexAiGeminiConfig correspondingVertexAiConfig(String configName) {
        return NamedConfigUtil.isDefault((String)configName) ? ((LangChain4jVertexAiGeminiConfig)this.runtimeConfig.getValue()).defaultConfig() : ((LangChain4jVertexAiGeminiConfig)this.runtimeConfig.getValue()).namedConfig().get(configName);
    }

    private static ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{VertexAiGeminiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem("SRCFG00014: The config property quarkus.langchain4j.vertexai.gemini%s%s is required but it could not be found in any config source".formatted(NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

