/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.tavily;

import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import io.quarkiverse.langchain4j.tavily.SearchDepth;
import io.quarkiverse.langchain4j.tavily.ShadowSensitiveData;
import io.quarkiverse.langchain4j.tavily.runtime.TavilyClient;
import io.quarkiverse.langchain4j.tavily.runtime.TavilyResponse;
import io.quarkiverse.langchain4j.tavily.runtime.TavilySearchRequest;
import io.quarkiverse.langchain4j.tavily.runtime.TavilySearchResult;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusTavilyWebSearchEngine
implements WebSearchEngine {
    private final TavilyClient tavilyClient;
    private final String apiKey;
    private final Integer maxResults;
    private final SearchDepth searchDepth;
    private final boolean includeAnswer;
    private final boolean includeRawContent;
    private final List<String> includeDomains;
    private final List<String> excludeDomains;

    public QuarkusTavilyWebSearchEngine(String baseUrl, String apiKey, Integer maxResults, Duration timeout, boolean logRequests, boolean logResponses, SearchDepth searchDepth, boolean includeAnswer, boolean includeRawContent, List<String> includeDomains, List<String> excludeDomains) {
        this.apiKey = apiKey;
        this.maxResults = maxResults;
        this.searchDepth = searchDepth;
        this.includeAnswer = includeAnswer;
        this.includeRawContent = includeRawContent;
        this.includeDomains = includeDomains;
        this.excludeDomains = excludeDomains;
        try {
            QuarkusRestClientBuilder builder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS);
            if (logRequests || logResponses) {
                builder = builder.loggingScope(LoggingScope.REQUEST_RESPONSE).clientLogger((ClientLogger)new TavilyClientLogger(logRequests, logResponses));
            }
            this.tavilyClient = (TavilyClient)builder.build(TavilyClient.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public WebSearchResults search(WebSearchRequest webSearchRequest) {
        TavilySearchRequest tavilySearchRequest = new TavilySearchRequest(this.apiKey, webSearchRequest.searchTerms(), this.searchDepth.toString().toLowerCase(), this.includeAnswer, this.includeRawContent, webSearchRequest.maxResults() != null ? webSearchRequest.maxResults() : this.maxResults, this.includeDomains, this.excludeDomains);
        TavilyResponse tavilyResponse = this.tavilyClient.search(tavilySearchRequest);
        List results = tavilyResponse.getResults().stream().map(QuarkusTavilyWebSearchEngine::toWebSearchOrganicResult).collect(Collectors.toList());
        if (tavilyResponse.getAnswer() != null) {
            WebSearchOrganicResult answerResult = WebSearchOrganicResult.from((String)"Tavily Search API", (URI)URI.create("https://tavily.com/"), (String)tavilyResponse.getAnswer(), null);
            results.add(0, answerResult);
        }
        return WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)Long.valueOf(results.size())), results);
    }

    private static WebSearchOrganicResult toWebSearchOrganicResult(TavilySearchResult tavilySearchResult) {
        return WebSearchOrganicResult.from((String)tavilySearchResult.getTitle(), (URI)URI.create(tavilySearchResult.getUrl().replaceAll(" ", "%20")), (String)tavilySearchResult.getContent(), (String)tavilySearchResult.getRawContent(), Collections.singletonMap("score", String.valueOf(tavilySearchResult.getScore())));
    }

    static class TavilyClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(TavilyClientLogger.class);
        private final boolean logRequests;
        private final boolean logResponses;

        public TavilyClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(this){
                final /* synthetic */ TavilyClientLogger this$0;
                {
                    this.this$0 = this$0;
                }

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.this$0.inOneLine(response.headers()), (Object)this.this$0.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return ShadowSensitiveData.process(body, "api_key");
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }
    }
}

