/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.redis.runtime;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;

public class RedisFilterMapper {
    public String map(Filter filter) {
        if (filter == null) {
            return "*";
        }
        return "(" + this.map0(filter) + ")";
    }

    private String map0(Filter filter) {
        if (filter instanceof IsEqualTo) {
            return this.mapEqual((IsEqualTo)filter);
        }
        if (filter instanceof IsNotEqualTo) {
            return this.mapNotEqual((IsNotEqualTo)filter);
        }
        if (filter instanceof IsGreaterThan) {
            return this.mapGreaterThan((IsGreaterThan)filter);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            return this.mapGreaterThanOrEqual((IsGreaterThanOrEqualTo)filter);
        }
        if (filter instanceof IsLessThan) {
            return this.mapLessThan((IsLessThan)filter);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            return this.mapLessThanOrEqual((IsLessThanOrEqualTo)filter);
        }
        if (filter instanceof IsIn) {
            return this.mapIn((IsIn)filter);
        }
        if (filter instanceof IsNotIn) {
            return this.mapNotIn((IsNotIn)filter);
        }
        if (filter instanceof And) {
            return this.mapAnd((And)filter);
        }
        if (filter instanceof Not) {
            return this.mapNot((Not)filter);
        }
        if (filter instanceof Or) {
            return this.mapOr((Or)filter);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String mapEqual(IsEqualTo op) {
        if (!(op.comparisonValue() instanceof Number)) {
            throw new UnsupportedOperationException("Redis embedding store currently only supports filtering based on numeric fields.");
        }
        return "@" + op.key() + ":[" + String.valueOf(op.comparisonValue()) + " " + String.valueOf(op.comparisonValue()) + "]";
    }

    private String mapNotEqual(IsNotEqualTo op) {
        if (!(op.comparisonValue() instanceof Number)) {
            throw new UnsupportedOperationException("Redis embedding store currently only supports filtering based on numeric fields.");
        }
        return "-@" + op.key() + ":[" + String.valueOf(op.comparisonValue()) + " " + String.valueOf(op.comparisonValue()) + "]";
    }

    private String mapGreaterThan(IsGreaterThan op) {
        if (!(op.comparisonValue() instanceof Number)) {
            throw new UnsupportedOperationException("Redis embedding store currently only supports filtering based on numeric fields.");
        }
        return "@" + op.key() + ":[(" + String.valueOf(op.comparisonValue()) + " inf]";
    }

    private String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo op) {
        if (!(op.comparisonValue() instanceof Number)) {
            throw new UnsupportedOperationException("Redis embedding store currently only supports filtering based on numeric fields.");
        }
        return "@" + op.key() + ":[" + String.valueOf(op.comparisonValue()) + " inf]";
    }

    private String mapLessThan(IsLessThan op) {
        if (!(op.comparisonValue() instanceof Number)) {
            throw new UnsupportedOperationException("Redis embedding store currently only supports filtering based on numeric fields.");
        }
        return "@" + op.key() + ":[-inf (" + String.valueOf(op.comparisonValue()) + "]";
    }

    private String mapLessThanOrEqual(IsLessThanOrEqualTo op) {
        if (!(op.comparisonValue() instanceof Number)) {
            throw new UnsupportedOperationException("Redis embedding store currently only supports filtering based on numeric fields.");
        }
        return "@" + op.key() + ":[-inf " + String.valueOf(op.comparisonValue()) + "]";
    }

    private String mapIn(IsIn op) {
        throw new UnsupportedOperationException();
    }

    private String mapNotIn(IsNotIn op) {
        throw new UnsupportedOperationException();
    }

    private String mapAnd(And op) {
        return this.map0(op.left()) + " " + this.map0(op.right());
    }

    private String mapNot(Not op) {
        throw new UnsupportedOperationException();
    }

    private String mapOr(Or op) {
        throw new UnsupportedOperationException();
    }
}

