/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.devui;

import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.openai.internal.OpenAiClient;
import dev.langchain4j.model.openai.internal.moderation.Categories;
import dev.langchain4j.model.openai.internal.moderation.CategoryScores;
import dev.langchain4j.model.openai.internal.moderation.ModerationRequest;
import dev.langchain4j.model.openai.internal.moderation.ModerationResponse;
import dev.langchain4j.model.openai.internal.moderation.ModerationResult;
import io.quarkiverse.langchain4j.openai.common.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.openai.runtime.config.LangChain4jOpenAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;
import java.time.Duration;

public class OpenAiModerationModelsJsonRPCService {
    @Inject
    LangChain4jOpenAiConfig config;

    public JsonObject moderate(String configuration, String modelName, String prompt) {
        if (NamedConfigUtil.isDefault((String)configuration) && this.config.defaultConfig().apiKey().equals("dummy")) {
            throw new RuntimeException("OpenAI API key is not configured. Please specify the key in the `quarkus.langchain4j.openai.api-key` configuration property.");
        }
        LangChain4jOpenAiConfig.OpenAiConfig clientConfig = NamedConfigUtil.isDefault((String)configuration) ? this.config.defaultConfig() : this.config.namedConfig().get(configuration);
        QuarkusOpenAiClient client = ((QuarkusOpenAiClient.Builder)((QuarkusOpenAiClient.Builder)((QuarkusOpenAiClient.Builder)QuarkusOpenAiClient.builder().openAiApiKey(clientConfig.apiKey()).baseUrl(clientConfig.baseUrl())).callTimeout(clientConfig.timeout().orElse(Duration.ofSeconds(10L))).connectTimeout(clientConfig.timeout().orElse(Duration.ofSeconds(10L)))).readTimeout(clientConfig.timeout().orElse(Duration.ofSeconds(10L)))).writeTimeout(clientConfig.timeout().orElse(Duration.ofSeconds(10L))).build();
        ModerationRequest request = ModerationRequest.builder().model(modelName).input(prompt).build();
        ModerationResponse response = (ModerationResponse)RetryUtils.withRetry(() -> OpenAiModerationModelsJsonRPCService.lambda$moderate$0((OpenAiClient)client, request), (int)clientConfig.maxRetries());
        ModerationResult moderationResult = (ModerationResult)response.results().get(0);
        CategoryScores categoryScores = moderationResult.categoryScores();
        Categories categoryFlags = moderationResult.categories();
        JsonObject result = new JsonObject();
        result.put("flagged", (Object)moderationResult.isFlagged());
        JsonArray categories = new JsonArray();
        this.addCategoryScore(categories, "sexual", categoryScores.sexual(), categoryFlags.sexual());
        this.addCategoryScore(categories, "hate", categoryScores.hate(), categoryFlags.hate());
        this.addCategoryScore(categories, "hate-threatening", categoryScores.hateThreatening(), categoryFlags.hateThreatening());
        this.addCategoryScore(categories, "self-harm", categoryScores.selfHarm(), categoryFlags.selfHarm());
        this.addCategoryScore(categories, "violence", categoryScores.violence(), categoryFlags.violence());
        this.addCategoryScore(categories, "violence-graphic", categoryScores.violenceGraphic(), categoryFlags.violenceGraphic());
        this.addCategoryScore(categories, "sexual-minors", categoryScores.sexualMinors(), categoryFlags.sexualMinors());
        result.put("categories", (Object)categories);
        return result;
    }

    private void addCategoryScore(JsonArray categories, String name, Double score, Boolean flagged) {
        if (score != null) {
            JsonObject categoryScore = new JsonObject();
            categoryScore.put("name", (Object)name);
            categoryScore.put("flagged", (Object)flagged);
            categoryScore.put("score", (Object)score);
            categories.add((Object)categoryScore);
        }
    }

    private static /* synthetic */ ModerationResponse lambda$moderate$0(OpenAiClient client, ModerationRequest request) throws Exception {
        return (ModerationResponse)client.moderation(request).execute();
    }
}

