/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime.http;

import io.quarkiverse.langchain4j.mcp.auth.McpClientAuthProvider;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

class McpClientAuthFilter
implements ResteasyReactiveClientRequestFilter {
    McpClientAuthProvider authorizer;

    public McpClientAuthFilter(McpClientAuthProvider authorizer) {
        this.authorizer = authorizer;
    }

    public void filter(final ResteasyReactiveClientRequestContext requestContext) {
        Executor executorService = this.createExecutor();
        requestContext.suspend();
        executorService.execute(new Runnable(){
            final /* synthetic */ McpClientAuthFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.setAuthorization(requestContext);
                    requestContext.resume();
                }
                catch (Exception e) {
                    requestContext.resume((Throwable)e);
                }
            }
        });
    }

    private Executor createExecutor() {
        InstanceHandle executor = Arc.container().instance(ManagedExecutor.class, new Annotation[0]);
        return executor.isAvailable() ? (Executor)executor.get() : Infrastructure.getDefaultExecutor();
    }

    private void setAuthorization(ResteasyReactiveClientRequestContext requestContext) {
        String authValue = this.authorizer.getAuthorization(new AuthInputImpl(requestContext.getMethod(), requestContext.getUri(), (MultivaluedMap<String, Object>)requestContext.getHeaders()));
        if (authValue != null) {
            requestContext.getHeaders().putSingle((Object)"Authorization", (Object)authValue);
        }
    }

    static final class AuthInputImpl
    extends Record
    implements McpClientAuthProvider.Input {
        private final String method;
        private final URI uri;
        private final MultivaluedMap<String, Object> headers;

        AuthInputImpl(String method, URI uri, MultivaluedMap<String, Object> headers) {
            this.method = method;
            this.uri = uri;
            this.headers = headers;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this, o);
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        public MultivaluedMap<String, Object> headers() {
            return this.headers;
        }
    }
}

