/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime.devui.json;

import dev.langchain4j.model.chat.request.json.JsonAnyOfSchema;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNullSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import java.util.stream.Collectors;

public class JsonSchemaToExampleStringHelper {
    public static String generateExampleStringFromSchema(JsonSchemaElement element) {
        if (element instanceof JsonBooleanSchema) {
            return "true";
        }
        if (element instanceof JsonNumberSchema) {
            return "1.0";
        }
        if (element instanceof JsonStringSchema) {
            return "\"example\"";
        }
        if (element instanceof JsonIntegerSchema) {
            return "1";
        }
        if (element instanceof JsonNullSchema) {
            return "null";
        }
        if (element instanceof JsonObjectSchema) {
            JsonObjectSchema schema = (JsonObjectSchema)element;
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            String example = schema.properties().entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\": " + JsonSchemaToExampleStringHelper.generateExampleStringFromSchema((JsonSchemaElement)entry.getValue())).collect(Collectors.joining(", "));
            builder.append(example);
            builder.append("}");
            return builder.toString();
        }
        if (element instanceof JsonArraySchema) {
            JsonArraySchema schema = (JsonArraySchema)element;
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(JsonSchemaToExampleStringHelper.generateExampleStringFromSchema(schema.items()));
            builder.append("]");
            return builder.toString();
        }
        if (element instanceof JsonAnyOfSchema) {
            JsonAnyOfSchema schema = (JsonAnyOfSchema)element;
            return JsonSchemaToExampleStringHelper.generateExampleStringFromSchema((JsonSchemaElement)schema.anyOf().get(0));
        }
        throw new UnsupportedOperationException("Unsupported schema type: " + String.valueOf(element.getClass()));
    }
}

