/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import io.quarkiverse.langchain4j.gemini.common.Schema;
import io.quarkiverse.langchain4j.gemini.common.Type;
import java.util.Map;
import java.util.stream.Collectors;

public class SchemaMapper {
    public static Schema fromJsonSchemaToSchema(JsonSchema jsonSchema) {
        return SchemaMapper.fromJsonSchemaToSchema(jsonSchema.rootElement());
    }

    static Schema fromJsonSchemaToSchema(JsonSchemaElement jsonSchema) {
        Schema.Builder schemaBuilder = Schema.builder();
        if (jsonSchema instanceof JsonStringSchema) {
            JsonStringSchema jsonStringSchema = (JsonStringSchema)jsonSchema;
            schemaBuilder.description(jsonStringSchema.description());
            schemaBuilder.type(Type.STRING);
        } else if (jsonSchema instanceof JsonBooleanSchema) {
            JsonBooleanSchema jsonBooleanSchema = (JsonBooleanSchema)jsonSchema;
            schemaBuilder.description(jsonBooleanSchema.description());
            schemaBuilder.type(Type.BOOLEAN);
        } else if (jsonSchema instanceof JsonNumberSchema) {
            JsonNumberSchema jsonNumberSchema = (JsonNumberSchema)jsonSchema;
            schemaBuilder.description(jsonNumberSchema.description());
            schemaBuilder.type(Type.NUMBER);
        } else if (jsonSchema instanceof JsonIntegerSchema) {
            JsonIntegerSchema jsonIntegerSchema = (JsonIntegerSchema)jsonSchema;
            schemaBuilder.description(jsonIntegerSchema.description());
            schemaBuilder.type(Type.INTEGER);
        } else if (jsonSchema instanceof JsonEnumSchema) {
            JsonEnumSchema jsonEnumSchema = (JsonEnumSchema)jsonSchema;
            schemaBuilder.description(jsonEnumSchema.description());
            schemaBuilder.type(Type.STRING);
            schemaBuilder.enumeration(jsonEnumSchema.enumValues());
        } else if (jsonSchema instanceof JsonObjectSchema) {
            JsonObjectSchema jsonObjectSchema = (JsonObjectSchema)jsonSchema;
            schemaBuilder.description(jsonObjectSchema.description());
            schemaBuilder.type(Type.OBJECT);
            if (jsonObjectSchema.properties() != null) {
                Map properties = jsonObjectSchema.properties();
                Map<String, Schema> mappedProperties = properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SchemaMapper.fromJsonSchemaToSchema((JsonSchemaElement)entry.getValue())));
                schemaBuilder.properties(mappedProperties);
            }
            if (jsonObjectSchema.required() != null) {
                schemaBuilder.required(jsonObjectSchema.required());
            }
        } else if (jsonSchema instanceof JsonArraySchema) {
            JsonArraySchema jsonArraySchema = (JsonArraySchema)jsonSchema;
            schemaBuilder.description(jsonArraySchema.description());
            schemaBuilder.type(Type.ARRAY);
            if (jsonArraySchema.items() != null) {
                schemaBuilder.items(SchemaMapper.fromJsonSchemaToSchema(jsonArraySchema.items()));
            }
        } else {
            throw new IllegalArgumentException("Unsupported JsonSchemaElement type: " + String.valueOf(jsonSchema.getClass()));
        }
        return schemaBuilder.build();
    }
}

