/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.gemini.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.langchain4j.gemini.common.Type;
import java.util.List;
import java.util.Map;

public class Schema {
    private final Type type;
    private final String format;
    private final String description;
    private final Boolean nullable;
    @JsonProperty(value="enum")
    private final List<String> enumeration;
    private final String maxItems;
    private final Map<String, Schema> properties;
    private final List<String> required;
    private final Schema items;

    public Schema(Builder builder) {
        this.type = builder.type;
        this.format = builder.format;
        this.description = builder.description;
        this.nullable = builder.nullable;
        this.enumeration = builder.enumeration;
        this.maxItems = builder.maxItems;
        this.properties = builder.properties;
        this.required = builder.required;
        this.items = builder.items;
    }

    public Type getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public List<String> getEnumeration() {
        return this.enumeration;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public Schema getItems() {
        return this.items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Type type;
        private String format;
        private String description;
        private Boolean nullable;
        private List<String> enumeration;
        private String maxItems;
        private Map<String, Schema> properties;
        private List<String> required;
        private Schema items;

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder nullable(Boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder enumeration(List<String> enumeration) {
            this.enumeration = enumeration;
            return this;
        }

        public Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder properties(Map<String, Schema> properties) {
            this.properties = properties;
            return this;
        }

        public Builder required(List<String> required) {
            this.required = required;
            return this;
        }

        public Builder items(Schema items) {
            this.items = items;
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

