/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.easyrag;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagConfig;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagIngestor;
import io.quarkiverse.langchain4j.easyrag.runtime.IngestionStrategy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class EasyRagManualIngestion {
    @Inject
    EasyRagConfig config;

    public void ingest() {
        if (this.config.ingestionStrategy() != IngestionStrategy.MANUAL) {
            throw new IllegalStateException("Manual ingestion trigger called when `quarkus.langchain4j.easy-rag.ingestion-strategy` is not MANUAL");
        }
        EmbeddingModel embeddingModel = (EmbeddingModel)CDI.current().select(EmbeddingModel.class, new Annotation[0]).get();
        EmbeddingStore embeddingStore = (EmbeddingStore)CDI.current().select(EmbeddingStore.class, new Annotation[0]).get();
        EasyRagIngestor ingestor = new EasyRagIngestor(embeddingModel, (EmbeddingStore<TextSegment>)embeddingStore, this.config);
        ingestor.ingest();
    }
}

