/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.ClientInjectionPoint;
import io.quarkiverse.cxf.CxfClientProducer;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.HTTPConduitImpl;
import io.quarkiverse.cxf.annotation.CXFClient;
import io.quarkiverse.cxf.deployment.ClientSeiBuildItem;
import io.quarkiverse.cxf.deployment.CxfClientBuildItem;
import io.quarkiverse.cxf.deployment.CxfDeploymentUtils;
import io.quarkiverse.cxf.deployment.CxfDotNames;
import io.quarkiverse.cxf.deployment.RuntimeBusCustomizerBuildItem;
import io.quarkiverse.cxf.graal.QuarkusCxfFeature;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.xml.ws.BindingProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.wsdl11.CatalogWSDLLocator;
import org.apache.cxf.wsdl11.WSDLManagerImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class CxfClientProcessor {
    private static final Logger LOGGER = Logger.getLogger(CxfClientProcessor.class);

    @BuildStep
    void collectClients(CxfFixedConfig config, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<NativeImageFeatureBuildItem> nativeImageFeatures, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, BuildProducer<CxfClientBuildItem> clients, BuildProducer<ClientSeiBuildItem> clientSeis) {
        IndexView index = combinedIndexBuildItem.getIndex();
        AtomicBoolean hasRuntimeInitializedProxy = new AtomicBoolean(false);
        Map<String, CxfFixedConfig.ClientFixedConfig> clientSEIsInUse = CxfClientProcessor.findClientSEIsInUse(index, config);
        CxfDeploymentUtils.webServiceAnnotations(index).forEach(annotation -> {
            ClassInfo wsClassInfo = annotation.target().asClass();
            CxfFixedConfig.ClientFixedConfig clientConfig = (CxfFixedConfig.ClientFixedConfig)clientSEIsInUse.get(wsClassInfo.name().toString());
            if (clientConfig != null) {
                String wsNamespace;
                String wsName;
                String sei = wsClassInfo.name().toString();
                AnnotationInstance webserviceClient = CxfClientProcessor.findWebServiceClientAnnotation(index, wsClassInfo.name());
                if (webserviceClient != null) {
                    wsName = webserviceClient.value("name").asString();
                    wsNamespace = webserviceClient.value("targetNamespace").asString();
                } else {
                    wsName = Optional.ofNullable(annotation.value("serviceName")).map(AnnotationValue::asString).orElse("");
                    wsNamespace = Optional.ofNullable(annotation.value("targetNamespace")).map(AnnotationValue::asString).orElseGet(() -> CxfDeploymentUtils.getNameSpaceFromClassInfo(wsClassInfo));
                }
                String soapBinding = Optional.ofNullable(wsClassInfo.declaredAnnotation(CxfDotNames.BINDING_TYPE_ANNOTATION)).map(bindingType -> bindingType.value().asString()).orElse("http://schemas.xmlsoap.org/wsdl/soap/http");
                ProxyInfo proxyInfo = ProxyInfo.of(Optional.ofNullable(clientConfig.native_()).map(native_ -> native_.runtimeInitialized()).orElse(false), wsClassInfo, index);
                proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(proxyInfo.interfaces));
                clients.produce((BuildItem)new CxfClientBuildItem(sei, soapBinding, wsNamespace, wsName, proxyInfo.isRuntimeInitialized));
                clientSeis.produce((BuildItem)new ClientSeiBuildItem(sei));
                hasRuntimeInitializedProxy.set(hasRuntimeInitializedProxy.get() || proxyInfo.isRuntimeInitialized);
            }
        });
        if (hasRuntimeInitializedProxy.get()) {
            nativeImageFeatures.produce((BuildItem)new NativeImageFeatureBuildItem(QuarkusCxfFeature.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startClient(CXFRecorder recorder, List<CxfClientBuildItem> clients, BuildProducer<SyntheticBeanBuildItem> synthetics) {
        clients.stream().map(client -> new CXFClientData(client.getSoapBinding(), client.getSei(), client.getWsName(), client.getWsNamespace(), client.isProxyClassRuntimeInitialized())).map(cxf -> {
            LOGGER.debugf("producing dedicated CXFClientInfo bean named '%s' for SEI %s", (Object)cxf.getSei(), (Object)cxf.getSei());
            return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(CXFClientData.class).named(cxf.getSei())).runtimeValue(recorder.cxfClientData(cxf)).unremovable()).setRuntimeInit().done();
        }).forEach(arg_0 -> synthetics.produce(arg_0));
    }

    private static AnnotationInstance findWebServiceClientAnnotation(IndexView index, DotName seiName) {
        Collection annotations = index.getAnnotations(CxfDotNames.WEBSERVICE_CLIENT);
        for (AnnotationInstance annotation : annotations) {
            ClassInfo targetClass = annotation.target().asClass();
            for (MethodInfo method : targetClass.methods()) {
                if (!method.returnType().name().equals((Object)seiName)) continue;
                return annotation;
            }
        }
        return null;
    }

    public static Stream<ClientInjectionPoint> findClientInjectionPoints(IndexView index) {
        return index.getAnnotations(CxfDotNames.CXFCLIENT_ANNOTATION).stream().map(annotationInstance -> {
            AnnotationTarget target = annotationInstance.target();
            Type type = switch (target.kind()) {
                case AnnotationTarget.Kind.FIELD -> target.asField().type();
                case AnnotationTarget.Kind.METHOD_PARAMETER -> {
                    MethodParameterInfo paramInfo = target.asMethodParameter();
                    MethodInfo method = paramInfo.method();
                    yield (Type)method.parameterTypes().get(paramInfo.position());
                }
                default -> null;
            };
            if (type != null) {
                type = type.name().equals((Object)CxfDotNames.INJECT_INSTANCE) ? (Type)type.asParameterizedType().arguments().get(0) : type;
                String typeName = type.name().toString();
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> sei = Class.forName(typeName, true, cl);
                    AnnotationValue value = annotationInstance.value();
                    return new ClientInjectionPoint(value != null ? value.asString() : "", sei);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load Service Endpoint Interface " + typeName);
                }
            }
            return null;
        }).filter(ip -> ip != null).distinct();
    }

    private static Map<String, CxfFixedConfig.ClientFixedConfig> findClientSEIsInUse(IndexView index, CxfFixedConfig config) {
        TreeMap<String, CxfFixedConfig.ClientFixedConfig> seiToClientConfig = new TreeMap<String, CxfFixedConfig.ClientFixedConfig>();
        CxfClientProcessor.findClientInjectionPoints(index).forEach(clientInjectionPoint -> {
            String sei = clientInjectionPoint.getSei().getName();
            CxfFixedConfig.ClientFixedConfig clientConfig = CxfClientProcessor.findClientConfig(config, clientInjectionPoint.getConfigKey(), sei);
            seiToClientConfig.put(sei, clientConfig);
        });
        return seiToClientConfig;
    }

    static CxfFixedConfig.ClientFixedConfig findClientConfig(CxfFixedConfig config, String key, String serviceInterfaceName) {
        if (key != null && !key.isEmpty()) {
            CxfFixedConfig.ClientFixedConfig result = (CxfFixedConfig.ClientFixedConfig)config.clients().get(key);
            if (result == null) {
                return CxfFixedConfig.ClientFixedConfig.createDefault();
            }
            return result;
        }
        List configsBySei = config.clients().entrySet().stream().filter(cl -> serviceInterfaceName.equals(((CxfFixedConfig.ClientFixedConfig)cl.getValue()).serviceInterface().orElse(null))).filter(cl -> !((CxfFixedConfig.ClientFixedConfig)cl.getValue()).alternative()).collect(Collectors.toList());
        switch (configsBySei.size()) {
            case 0: {
                return CxfFixedConfig.ClientFixedConfig.createDefault();
            }
            case 1: {
                return (CxfFixedConfig.ClientFixedConfig)((Map.Entry)configsBySei.get(0)).getValue();
            }
        }
        throw new IllegalStateException("quarkus.cxf.*.service-interface = " + serviceInterfaceName + " with alternative = false expected once, but found " + configsBySei.size() + " times in " + configsBySei.stream().map(k -> "quarkus.cxf.\"" + (String)k.getKey() + "\".service-interface").collect(Collectors.joining(", ")));
    }

    @BuildStep
    void generateClientProducers(List<CxfClientBuildItem> clients, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        clients.stream().map(CxfClientBuildItem::getSei).forEach(sei -> this.generateCxfClientProducer((String)sei, generatedBeans, unremovableBeans));
        if (clients.stream().anyMatch(CxfClientBuildItem::isProxyClassRuntimeInitialized)) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker"}).build());
            this.copyMarkerInterfaceToApplication(generatedBeans);
        }
    }

    private void copyMarkerInterfaceToApplication(BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        byte[] bytes;
        try {
            bytes = IoUtil.readClassAsBytes((ClassLoader)this.getClass().getClassLoader(), (String)"io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker.class from quarkus-cxf-deployment jar");
        }
        String className = "io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker".replace('.', '/');
        generatedBeans.produce((BuildItem)new GeneratedBeanBuildItem(className, bytes));
    }

    private void generateCxfClientProducer(String sei, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        String cxfClientProducerClassName = sei + "CxfClientProducer";
        GeneratedBeanGizmoAdaptor classoutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classoutput).className(cxfClientProducerClassName).superClass(CxfClientProducer.class).build();){
            classCreator.addAnnotation(ApplicationScoped.class);
            FieldCreator info = (FieldCreator)classCreator.getFieldCreator("info", CXFClientData.class.getName()).setModifiers(1);
            info.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)sei)}));
            info.addAnnotation(AnnotationInstance.create((DotName)DotName.createSimple((String)Inject.class.getName()), null, (AnnotationValue[])new AnnotationValue[0]));
            try (MethodCreator createService = classCreator.getMethodCreator("createService", (Object)sei, new Object[]{InjectionPoint.class});){
                createService.addAnnotation(Produces.class);
                createService.addAnnotation(CXFClient.class);
                ResultHandle thisHandle = createService.getThis();
                ResultHandle injectionPointHandle = createService.getMethodParam(0);
                ResultHandle cxfClientInfoHandle = createService.readInstanceField(info.getFieldDescriptor(), thisHandle);
                MethodDescriptor loadCxfClient = MethodDescriptor.ofMethod(CxfClientProducer.class, (String)"loadCxfClient", (Object)"java.lang.Object", (Object[])new Object[]{InjectionPoint.class, CXFClientData.class});
                ResultHandle cxfClient = createService.invokeVirtualMethod(loadCxfClient, thisHandle, new ResultHandle[]{injectionPointHandle, cxfClientInfoHandle});
                createService.returnValue(createService.checkCast(cxfClient, sei));
            }
            createService = classCreator.getMethodCreator("closeClient", Void.TYPE, new Object[]{sei});
            try {
                AnnotatedElement clientParamAnnotations = createService.getParameterAnnotations(0);
                clientParamAnnotations.addAnnotation(Disposes.class);
                clientParamAnnotations.addAnnotation(CXFClient.class);
                ResultHandle thisHandle = createService.getThis();
                ResultHandle clientHandle = createService.getMethodParam(0);
                MethodDescriptor closeClient = MethodDescriptor.ofMethod(CxfClientProducer.class, (String)"closeCxfClient", Void.TYPE, (Class[])new Class[]{Object.class});
                createService.invokeVirtualMethod(closeClient, thisHandle, new ResultHandle[]{clientHandle});
                createService.returnVoid();
            }
            finally {
                if (createService != null) {
                    createService.close();
                }
            }
        }
        this.produceUnremovableBean(unremovableBeans, cxfClientProducerClassName);
    }

    private void produceUnremovableBean(BuildProducer<UnremovableBeanBuildItem> unremovables, String ... args) {
        Arrays.stream(args).map(UnremovableBeanBuildItem.BeanClassNameExclusion::new).map(UnremovableBeanBuildItem::new).forEach(arg_0 -> unremovables.produce(arg_0));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildTimeBusCustomizers(CXFRecorder recorder, CxfFixedConfig config, List<FeatureBuildItem> features, BuildProducer<RuntimeBusCustomizerBuildItem> customizers) {
        HTTPConduitImpl factory = config.httpConduitFactory().orElse(HTTPConduitImpl.QuarkusCXFDefault);
        switch (factory) {
            case CXFDefault: {
                break;
            }
            case QuarkusCXFDefault: 
            case VertxHttpClientHTTPConduitFactory: 
            case URLConnectionHTTPConduitFactory: {
                customizers.produce((BuildItem)new RuntimeBusCustomizerBuildItem((RuntimeValue<Consumer<Bus>>)recorder.setBusHTTPConduitFactory(factory)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + HTTPConduitImpl.class.getSimpleName() + " value: " + String.valueOf(config.httpConduitFactory()));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void runtimeBusCustomizers(CXFRecorder recorder, BuildProducer<RuntimeBusCustomizerBuildItem> customizers) {
        customizers.produce((BuildItem)new RuntimeBusCustomizerBuildItem((RuntimeValue<Consumer<Bus>>)recorder.busConfigForRetransmitCache()));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void workaroundAsyncWsdlInit(CXFRecorder recorder, BuildProducer<RuntimeBusCustomizerBuildItem> customizers) {
        customizers.produce((BuildItem)new RuntimeBusCustomizerBuildItem((RuntimeValue<Consumer<Bus>>)recorder.setQuarkusWSDLManager()));
    }

    @BuildStep
    ReflectiveClassBuildItem workaroundAsyncWsdlInit() {
        return ReflectiveClassBuildItem.builder((Class[])new Class[]{WSDLManagerImpl.class, CatalogWSDLLocator.class}).fields().build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void workaroundBadForceURLConnectionInit(CXFRecorder recorder) {
        recorder.workaroundBadForceURLConnectionInit();
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveClass() {
        return ReflectiveClassBuildItem.builder((Class[])new Class[]{HTTPTransportFactory.class}).fields().build();
    }

    private static class ProxyInfo {
        private final List<String> interfaces;
        private final boolean isRuntimeInitialized;

        public static ProxyInfo of(boolean refersToRuntimeInitializedClasses, ClassInfo wsClassInfo, IndexView index) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(wsClassInfo.name().toString());
            result.add(BindingProvider.class.getName());
            result.add("java.io.Closeable");
            result.add(Client.class.getName());
            if (refersToRuntimeInitializedClasses) {
                result.add("io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker");
            }
            return new ProxyInfo(result, refersToRuntimeInitializedClasses);
        }

        private ProxyInfo(List<String> interfaces, boolean isRuntimeInitialized) {
            this.interfaces = interfaces;
            this.isRuntimeInitialized = isRuntimeInitialized;
        }
    }
}

