/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sns.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonHttpClients;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.spi.EventLoopGroupBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkus.amazon.sns.runtime.SnsBuildTimeConfig;
import io.quarkus.amazon.sns.runtime.SnsClientProducer;
import io.quarkus.amazon.sns.runtime.SnsRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

public class SnsProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_SNS = "amazon-sns";
    SnsBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_SNS;
    }

    protected String configName() {
        return "sns";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)SnsClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)SnsAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/sns/execution.interceptors";
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.unremovableOf(SnsClientProducer.class);
    }

    @BuildStep
    void setup(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        this.setupExtension(extensionSslNativeSupport, feature, interceptors);
    }

    @BuildStep
    void discover(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        this.discoverClient(beanRegistrationPhase, requireClientProducer);
    }

    @BuildStep
    void setupClient(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<AmazonClientBuildItem> clientProducer) {
        this.setupClient(clientRequirements, clientProducer, this.buildTimeConfig.sdk(), this.buildTimeConfig.syncClient(), this.buildTimeConfig.asyncClient());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<AmazonClientBuildItem> amazonClients, SnsRecorder recorder, AmazonClientApacheTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<AmazonClientBuildItem> amazonClients, SnsRecorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<AmazonClientBuildItem> amazonClients, SnsRecorder recorder, AmazonClientNettyTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports, EventLoopGroupBuildItem eventLoopSupplier) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports, eventLoopSupplier.getMainEventLoopGroup());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtAsyncTransport(List<AmazonClientBuildItem> amazonClients, SnsRecorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createAwsCrtAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(SnsRecorder recorder, AmazonClientCommonRecorder commonRecorder, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, ExecutorBuildItem executorBuildItem) {
        this.createClientBuilders((AmazonClientRecorder)recorder, commonRecorder, (HasSdkBuildTimeConfig)this.buildTimeConfig, syncTransports, asyncTransports, SnsClientBuilder.class, SnsAsyncClientBuilder.class, null, syntheticBeans, clientSync, clientAsync, executorBuildItem);
    }
}

