/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.enhanced.runtime;

import io.quarkus.amazon.dynamodb.enhanced.runtime.DynamoDbEnhancedBuildTimeConfig;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.ExtensionResolver;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@Recorder
public class DynamodbEnhancedClientRecorder {
    private static final Log LOG = LogFactory.getLog(DynamodbEnhancedClientRecorder.class);
    DynamoDbEnhancedBuildTimeConfig buildTimeConfig;

    public DynamodbEnhancedClientRecorder(DynamoDbEnhancedBuildTimeConfig buildTimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
    }

    public void createTableSchema(List<Class<?>> tableSchemClasses) {
        for (Class<?> tableSchemaClass : tableSchemClasses) {
            TableSchema.fromClass(tableSchemaClass);
        }
    }

    public RuntimeValue<DynamoDbEnhancedClientExtension> createExtensionList() {
        ArrayList<DynamoDbEnhancedClientExtension> extensions = new ArrayList<DynamoDbEnhancedClientExtension>();
        for (String item : this.buildTimeConfig.clientExtensions().orElse(Collections.emptyList())) {
            DynamoDbEnhancedClientExtension extension = this.createExtension(item.trim());
            if (!Objects.nonNull(extension)) continue;
            extensions.add(extension);
        }
        if (extensions.isEmpty()) {
            extensions.addAll(ExtensionResolver.defaultExtensions());
        }
        return new RuntimeValue((Object)ExtensionResolver.resolveExtensions(extensions));
    }

    private DynamoDbEnhancedClientExtension createExtension(String extensionClassName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(extensionClassName, false, Thread.currentThread().getContextClassLoader());
            Method builderMethod = clazz.getMethod("builder", new Class[0]);
            Object builder = builderMethod.invoke(null, new Object[0]);
            DynamoDbEnhancedClientExtension extension = (DynamoDbEnhancedClientExtension)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            return extension;
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            LOG.error((Object)("Unable to create extension " + extensionClassName), (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            try {
                return (DynamoDbEnhancedClientExtension)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.error((Object)("Unable to create extension " + extensionClassName), (Throwable)e);
                return null;
            }
        }
    }

    public Function<SyntheticCreationalContext<DynamoDbEnhancedClient>, DynamoDbEnhancedClient> createDynamoDbEnhancedClient(final RuntimeValue<DynamoDbEnhancedClientExtension> extensions) {
        return new Function<SyntheticCreationalContext<DynamoDbEnhancedClient>, DynamoDbEnhancedClient>(){

            @Override
            public DynamoDbEnhancedClient apply(SyntheticCreationalContext<DynamoDbEnhancedClient> context) {
                return DynamoDbEnhancedClient.builder().dynamoDbClient((DynamoDbClient)context.getInjectedReference(DynamoDbClient.class, new Annotation[0])).extensions(new DynamoDbEnhancedClientExtension[]{(DynamoDbEnhancedClientExtension)extensions.getValue()}).build();
            }
        };
    }

    public Function<SyntheticCreationalContext<DynamoDbEnhancedAsyncClient>, DynamoDbEnhancedAsyncClient> createDynamoDbEnhancedAsyncClient(final RuntimeValue<DynamoDbEnhancedClientExtension> extensions) {
        return new Function<SyntheticCreationalContext<DynamoDbEnhancedAsyncClient>, DynamoDbEnhancedAsyncClient>(){

            @Override
            public DynamoDbEnhancedAsyncClient apply(SyntheticCreationalContext<DynamoDbEnhancedAsyncClient> context) {
                return DynamoDbEnhancedAsyncClient.builder().dynamoDbClient((DynamoDbAsyncClient)context.getInjectedReference(DynamoDbAsyncClient.class, new Annotation[0])).extensions(new DynamoDbEnhancedClientExtension[]{(DynamoDbEnhancedClientExtension)extensions.getValue()}).build();
            }
        };
    }
}

