/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.AllureResultsReader;
import io.qameta.allure.ReadError;
import io.qameta.allure.model.Allure2ModelJackson;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileSystemResultsReader
implements AllureResultsReader {
    private final Path resultsDirectory;
    private final ObjectMapper mapper;
    private final List<ReadError> errors = new ArrayList<ReadError>();

    public FileSystemResultsReader(Path resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
        this.mapper = Allure2ModelJackson.createMapper();
    }

    @Override
    public Stream<TestResult> readTestResults() {
        return this.listFiles(this.resultsDirectory, "*-result.json").map(this::readTestResult).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public Stream<TestResultContainer> readTestResultsContainers() {
        return this.listFiles(this.resultsDirectory, "*-container.json").map(this::readTestResultContainer).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public Stream<String> findAllAttachments() {
        return this.listFiles(this.resultsDirectory, "*-attachment*").map(Path::getFileName).map(Path::toString);
    }

    @Override
    public InputStream readAttachment(String source) throws IOException {
        return Files.newInputStream(this.resultsDirectory.resolve(source), new OpenOption[0]);
    }

    @Override
    public List<ReadError> getErrors() {
        return this.errors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<TestResult> readTestResult(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            Optional<Object> optional = Optional.ofNullable(this.mapper.readValue(is, TestResult.class));
            return optional;
        }
        catch (IOException e) {
            this.errors.add(new ReadError(e, "Could not read result file {}", file));
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<TestResultContainer> readTestResultContainer(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            Optional<Object> optional = Optional.ofNullable(this.mapper.readValue(is, TestResultContainer.class));
            return optional;
        }
        catch (IOException e) {
            this.errors.add(new ReadError(e, "Could not read result container file {}", file));
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stream<Path> listFiles(Path directory, String glob) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, glob);){
            Stream<Path> stream = StreamSupport.stream(directoryStream.spliterator(), false).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()).stream();
            return stream;
        }
        catch (IOException e) {
            this.errors.add(new ReadError(e, "Could not list files in directory {}", directory));
            return Stream.empty();
        }
    }
}

