/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.Param;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.util.NamingUtils;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public final class AspectUtils {
    private AspectUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static String getName(String nameTemplate, JoinPoint joinPoint) {
        return Optional.of(nameTemplate).filter(v -> !v.isEmpty()).map(value -> NamingUtils.processNameTemplate(value, AspectUtils.getParametersMap(joinPoint))).orElseGet(() -> ((Signature)joinPoint.getSignature()).getName());
    }

    @Deprecated
    public static Map<String, Object> getParametersMap(MethodSignature signature, Object ... args) {
        String[] parameterNames = signature.getParameterNames();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("method", signature.getName());
        for (int i = 0; i < Math.max(parameterNames.length, args.length); ++i) {
            params.put(parameterNames[i], args[i]);
            params.put(Integer.toString(i), args[i]);
        }
        return params;
    }

    public static Map<String, Object> getParametersMap(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Map<String, Object> params = AspectUtils.getParametersMap(methodSignature, joinPoint.getArgs());
        Optional.ofNullable(joinPoint.getThis()).ifPresent(objThis -> params.put("this", objThis));
        return params;
    }

    public static List<Parameter> getParameters(MethodSignature signature, Object ... args) {
        java.lang.reflect.Parameter[] params = signature.getMethod().getParameters();
        return IntStream.range(0, args.length).mapToObj(index -> {
            Parameter parameter = ResultsUtils.createParameter(signature.getParameterNames()[index], args[index]);
            java.lang.reflect.Parameter ref = params[index];
            Stream.of((Param[])ref.getAnnotationsByType(Param.class)).findFirst().ifPresent(param -> {
                Stream.of(param.value(), param.name()).map(String::trim).filter(name -> name.length() > 0).findFirst().ifPresent(arg_0 -> ((Parameter)parameter).setName(arg_0));
                parameter.setMode(param.mode());
                parameter.setExcluded(Boolean.valueOf(param.excluded()));
            });
            return parameter;
        }).collect(Collectors.toList());
    }

    @Deprecated
    public static String objectToString(Object object) {
        return ObjectUtils.toString(object);
    }
}

