/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal;

import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AllureStorage {
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public Optional<TestResultContainer> getContainer(String uuid) {
        return this.get(uuid, TestResultContainer.class);
    }

    public Optional<TestResult> getTestResult(String uuid) {
        return this.get(uuid, TestResult.class);
    }

    public Optional<FixtureResult> getFixture(String uuid) {
        return this.get(uuid, FixtureResult.class);
    }

    public Optional<StepResult> getStep(String uuid) {
        return this.get(uuid, StepResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<T> get(String uuid, Class<T> clazz) {
        this.lock.readLock().lock();
        try {
            Objects.requireNonNull(uuid, "Can't get item from storage: uuid can't be null");
            Optional<Object> optional = Optional.ofNullable(this.storage.get(uuid)).filter(clazz::isInstance).map(clazz::cast);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T put(String uuid, T item) {
        this.lock.writeLock().lock();
        try {
            Objects.requireNonNull(uuid, "Can't put item to storage: uuid can't be null");
            this.storage.put(uuid, item);
            T t = item;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(String uuid) {
        this.lock.writeLock().lock();
        try {
            Objects.requireNonNull(uuid, "Can't remove item from storage: uuid can't be null");
            this.storage.remove(uuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

