/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.Nameable;
import io.qameta.allure.entity.Parameter;
import io.qameta.allure.entity.Parameterizable;
import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Statusable;
import io.qameta.allure.entity.Time;
import io.qameta.allure.entity.Timeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class TestResult
implements Serializable,
Nameable,
Parameterizable,
Statusable,
Timeable {
    private static final long serialVersionUID = 1L;
    protected String uid;
    protected String name;
    protected String fullName;
    protected String historyId;
    protected String testId;
    protected Time time = new Time();
    protected String description;
    protected String descriptionHtml;
    protected Status status;
    protected String statusMessage;
    protected String statusTrace;
    protected boolean flaky;
    protected boolean newFailed;
    protected boolean newBroken;
    protected boolean newPassed;
    protected int retriesCount;
    protected boolean retriesStatusChange;
    protected List<StageResult> beforeStages = new ArrayList<StageResult>();
    protected StageResult testStage;
    protected List<StageResult> afterStages = new ArrayList<StageResult>();
    protected List<Label> labels = new ArrayList<Label>();
    protected List<Parameter> parameters = new ArrayList<Parameter>();
    protected List<Link> links = new ArrayList<Link>();
    protected boolean hidden;
    protected boolean retry;
    protected final Map<String, Object> extra = new HashMap<String, Object>();

    @JsonProperty
    public String getSource() {
        return this.getUid() + ".json";
    }

    public void addExtraBlock(String blockName, Object block) {
        this.extra.put(blockName, block);
    }

    public <T> T getExtraBlock(String blockName, T defaultValue) {
        return (T)this.extra.computeIfAbsent(blockName, name -> defaultValue);
    }

    public <T> T getExtraBlock(String blockName) {
        return (T)this.extra.get(blockName);
    }

    public boolean hasExtraBlock(String blockName) {
        return this.extra.containsKey(blockName);
    }

    public <T> T findAllLabels(LabelName name, Collector<String, ?, T> collector) {
        return this.findAllLabels(name.value(), collector);
    }

    public <T> T findAllLabels(String name, Collector<String, ?, T> collector) {
        return this.getLabels().stream().filter(label -> name.equals(label.getName())).map(Label::getValue).collect(collector);
    }

    public List<String> findAllLabels(LabelName name) {
        return this.findAllLabels(name, Collectors.toList());
    }

    public List<String> findAllLabels(String name) {
        return this.findAllLabels(name, Collectors.toList());
    }

    public Optional<String> findOneLabel(LabelName name) {
        return this.findOneLabel(name.value());
    }

    public Optional<String> findOneLabel(String name) {
        return this.getLabels().stream().filter(label -> name.equals(label.getName())).findAny().map(Label::getValue);
    }

    public void addLabelIfNotExists(LabelName name, String value) {
        this.addLabelIfNotExists(name.value(), value);
    }

    public void addLabelIfNotExists(String name, String value) {
        if (value == null || name == null) {
            return;
        }
        Optional<String> any = this.getLabels().stream().map(Label::getName).filter(name::equals).findAny();
        if (!any.isPresent()) {
            this.addLabel(name, value);
        }
    }

    public void addLabel(String name, String value) {
        this.getLabels().add(new Label().setName(name).setValue(value));
    }

    public static Comparator<TestResult> comparingByTime() {
        return TestResult.comparingByTimeAsc().reversed();
    }

    public static Comparator<TestResult> comparingByTimeAsc() {
        return Comparator.comparing(TestResult::getTime, Comparator.nullsFirst(Comparator.comparing(Time::getStart, Comparator.nullsFirst(Comparator.naturalOrder()))));
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Label l : this.getLabels()) {
            map.put(l.getName(), l.getValue());
        }
        return map;
    }

    public String getUid() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getHistoryId() {
        return this.historyId;
    }

    public String getTestId() {
        return this.testId;
    }

    @Override
    public Time getTime() {
        return this.time;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionHtml() {
        return this.descriptionHtml;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getStatusTrace() {
        return this.statusTrace;
    }

    public boolean isFlaky() {
        return this.flaky;
    }

    public boolean isNewFailed() {
        return this.newFailed;
    }

    public boolean isNewBroken() {
        return this.newBroken;
    }

    public boolean isNewPassed() {
        return this.newPassed;
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }

    public boolean isRetriesStatusChange() {
        return this.retriesStatusChange;
    }

    public List<StageResult> getBeforeStages() {
        return this.beforeStages;
    }

    public StageResult getTestStage() {
        return this.testStage;
    }

    public List<StageResult> getAfterStages() {
        return this.afterStages;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public TestResult setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public TestResult setName(String name) {
        this.name = name;
        return this;
    }

    public TestResult setFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public TestResult setHistoryId(String historyId) {
        this.historyId = historyId;
        return this;
    }

    public TestResult setTestId(String testId) {
        this.testId = testId;
        return this;
    }

    public TestResult setTime(Time time) {
        this.time = time;
        return this;
    }

    public TestResult setDescription(String description) {
        this.description = description;
        return this;
    }

    public TestResult setDescriptionHtml(String descriptionHtml) {
        this.descriptionHtml = descriptionHtml;
        return this;
    }

    public TestResult setStatus(Status status) {
        this.status = status;
        return this;
    }

    public TestResult setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public TestResult setStatusTrace(String statusTrace) {
        this.statusTrace = statusTrace;
        return this;
    }

    public TestResult setFlaky(boolean flaky) {
        this.flaky = flaky;
        return this;
    }

    public TestResult setNewFailed(boolean newFailed) {
        this.newFailed = newFailed;
        return this;
    }

    public TestResult setNewBroken(boolean newBroken) {
        this.newBroken = newBroken;
        return this;
    }

    public TestResult setNewPassed(boolean newPassed) {
        this.newPassed = newPassed;
        return this;
    }

    public TestResult setRetriesCount(int retriesCount) {
        this.retriesCount = retriesCount;
        return this;
    }

    public TestResult setRetriesStatusChange(boolean retriesStatusChange) {
        this.retriesStatusChange = retriesStatusChange;
        return this;
    }

    public TestResult setBeforeStages(List<StageResult> beforeStages) {
        this.beforeStages = beforeStages;
        return this;
    }

    public TestResult setTestStage(StageResult testStage) {
        this.testStage = testStage;
        return this;
    }

    public TestResult setAfterStages(List<StageResult> afterStages) {
        this.afterStages = afterStages;
        return this;
    }

    public TestResult setLabels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public TestResult setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public TestResult setLinks(List<Link> links) {
        this.links = links;
        return this;
    }

    public TestResult setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public TestResult setRetry(boolean retry) {
        this.retry = retry;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestResult)) {
            return false;
        }
        TestResult other = (TestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFlaky() != other.isFlaky()) {
            return false;
        }
        if (this.isNewFailed() != other.isNewFailed()) {
            return false;
        }
        if (this.isNewBroken() != other.isNewBroken()) {
            return false;
        }
        if (this.isNewPassed() != other.isNewPassed()) {
            return false;
        }
        if (this.getRetriesCount() != other.getRetriesCount()) {
            return false;
        }
        if (this.isRetriesStatusChange() != other.isRetriesStatusChange()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isRetry() != other.isRetry()) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$historyId = this.getHistoryId();
        String other$historyId = other.getHistoryId();
        if (this$historyId == null ? other$historyId != null : !this$historyId.equals(other$historyId)) {
            return false;
        }
        String this$testId = this.getTestId();
        String other$testId = other.getTestId();
        if (this$testId == null ? other$testId != null : !this$testId.equals(other$testId)) {
            return false;
        }
        Time this$time = this.getTime();
        Time other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$descriptionHtml = this.getDescriptionHtml();
        String other$descriptionHtml = other.getDescriptionHtml();
        if (this$descriptionHtml == null ? other$descriptionHtml != null : !this$descriptionHtml.equals(other$descriptionHtml)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$statusMessage = this.getStatusMessage();
        String other$statusMessage = other.getStatusMessage();
        if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) {
            return false;
        }
        String this$statusTrace = this.getStatusTrace();
        String other$statusTrace = other.getStatusTrace();
        if (this$statusTrace == null ? other$statusTrace != null : !this$statusTrace.equals(other$statusTrace)) {
            return false;
        }
        List<StageResult> this$beforeStages = this.getBeforeStages();
        List<StageResult> other$beforeStages = other.getBeforeStages();
        if (this$beforeStages == null ? other$beforeStages != null : !((Object)this$beforeStages).equals(other$beforeStages)) {
            return false;
        }
        StageResult this$testStage = this.getTestStage();
        StageResult other$testStage = other.getTestStage();
        if (this$testStage == null ? other$testStage != null : !((Object)this$testStage).equals(other$testStage)) {
            return false;
        }
        List<StageResult> this$afterStages = this.getAfterStages();
        List<StageResult> other$afterStages = other.getAfterStages();
        if (this$afterStages == null ? other$afterStages != null : !((Object)this$afterStages).equals(other$afterStages)) {
            return false;
        }
        List<Label> this$labels = this.getLabels();
        List<Label> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        Map<String, Object> this$extra = this.getExtra();
        Map<String, Object> other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlaky() ? 79 : 97);
        result = result * 59 + (this.isNewFailed() ? 79 : 97);
        result = result * 59 + (this.isNewBroken() ? 79 : 97);
        result = result * 59 + (this.isNewPassed() ? 79 : 97);
        result = result * 59 + this.getRetriesCount();
        result = result * 59 + (this.isRetriesStatusChange() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isRetry() ? 79 : 97);
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $historyId = this.getHistoryId();
        result = result * 59 + ($historyId == null ? 43 : $historyId.hashCode());
        String $testId = this.getTestId();
        result = result * 59 + ($testId == null ? 43 : $testId.hashCode());
        Time $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $descriptionHtml = this.getDescriptionHtml();
        result = result * 59 + ($descriptionHtml == null ? 43 : $descriptionHtml.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $statusMessage = this.getStatusMessage();
        result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
        String $statusTrace = this.getStatusTrace();
        result = result * 59 + ($statusTrace == null ? 43 : $statusTrace.hashCode());
        List<StageResult> $beforeStages = this.getBeforeStages();
        result = result * 59 + ($beforeStages == null ? 43 : ((Object)$beforeStages).hashCode());
        StageResult $testStage = this.getTestStage();
        result = result * 59 + ($testStage == null ? 43 : ((Object)$testStage).hashCode());
        List<StageResult> $afterStages = this.getAfterStages();
        result = result * 59 + ($afterStages == null ? 43 : ((Object)$afterStages).hashCode());
        List<Label> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        Map<String, Object> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        return result;
    }

    public String toString() {
        return "TestResult(uid=" + this.getUid() + ", name=" + this.getName() + ", fullName=" + this.getFullName() + ", historyId=" + this.getHistoryId() + ", testId=" + this.getTestId() + ", time=" + this.getTime() + ", description=" + this.getDescription() + ", descriptionHtml=" + this.getDescriptionHtml() + ", status=" + this.getStatus() + ", statusMessage=" + this.getStatusMessage() + ", statusTrace=" + this.getStatusTrace() + ", flaky=" + this.isFlaky() + ", newFailed=" + this.isNewFailed() + ", newBroken=" + this.isNewBroken() + ", newPassed=" + this.isNewPassed() + ", retriesCount=" + this.getRetriesCount() + ", retriesStatusChange=" + this.isRetriesStatusChange() + ", beforeStages=" + this.getBeforeStages() + ", testStage=" + this.getTestStage() + ", afterStages=" + this.getAfterStages() + ", labels=" + this.getLabels() + ", parameters=" + this.getParameters() + ", links=" + this.getLinks() + ", hidden=" + this.isHidden() + ", retry=" + this.isRetry() + ", extra=" + this.getExtra() + ")";
    }
}

