/*
 * Decompiled with CFR 0.152.
 */
package com.github.baev;

import com.github.baev.BadXmlCharactersUtils;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class BadXmlCharactersFilterWriter
extends FilterWriter {
    public BadXmlCharactersFilterWriter(Path out) throws IOException {
        this(out, StandardCharsets.UTF_8);
    }

    public BadXmlCharactersFilterWriter(Path out, Charset encoding) throws IOException {
        this(Files.newBufferedWriter(out, encoding, new OpenOption[0]));
    }

    protected BadXmlCharactersFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        this.write(new char[]{(char)c}, 0, 1);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        BadXmlCharactersUtils.replaceBadXmlCharactersBySpace(cbuf, off, len);
        super.write(cbuf, off, len);
    }
}

