/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.selector;

import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.Selector;
import reactor.fn.Predicate;

public class ObjectSelector<K, T>
implements Selector<K>,
Predicate<K> {
    private final Object monitor = new Object();
    private final T object;

    public ObjectSelector(T object) {
        this.object = object;
    }

    public static <T> Selector<T> objectSelector(T obj) {
        return new ObjectSelector(obj);
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean matches(K key) {
        return (null != this.object || null == key) && this.object != null && this.object.equals(key);
    }

    @Override
    public HeaderResolver getHeaderResolver() {
        return null;
    }

    public boolean test(K t) {
        return this.matches(t);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ObjectSelector<K, T>(this.object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.monitor;
        synchronized (object) {
            return "Selector{object=" + this.object + '}';
        }
    }
}

