/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigClientOAuth2Properties;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRequestTemplateFactory;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.http.HttpHeaders;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestTemplate;

public class OAuth2ConfigDataLocationResolver
implements ConfigDataLocationResolver<ConfigServerConfigDataResource>,
Ordered {
    private final Log log;

    public OAuth2ConfigDataLocationResolver(DeferredLogFactory factory) {
        this.log = factory.getLog(OAuth2ConfigDataLocationResolver.class);
    }

    public boolean isResolvable(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location) {
        if (!location.hasPrefix("configserver:")) {
            return false;
        }
        Binder binder = resolverContext.getBinder();
        Boolean isConfigEnabled = (Boolean)binder.bind("spring.cloud.config.enabled", Boolean.class).orElse((Object)true);
        if (!isConfigEnabled.booleanValue()) {
            return false;
        }
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        ConfigClientOAuth2Properties oAuth2Properties = (ConfigClientOAuth2Properties)binder.bind("spring.cloud.config.client.oauth2", ConfigClientOAuth2Properties.class).orElse(null);
        ConfigClientProperties clientProperties = (ConfigClientProperties)binder.bind("spring.cloud.config", ConfigClientProperties.class).orElse((Object)new ConfigClientProperties((Environment)new StandardEnvironment()));
        bootstrapContext.registerIfAbsent(ConfigClientRequestTemplateFactory.class, context -> new OAuth2ConfigClientRequestTemplateFactory(this.log, clientProperties, oAuth2Properties));
        OAuth2ConfigClientRequestTemplateFactory factory = (OAuth2ConfigClientRequestTemplateFactory)((Object)bootstrapContext.get(ConfigClientRequestTemplateFactory.class));
        factory.update(clientProperties, oAuth2Properties);
        bootstrapContext.registerIfAbsent(RestTemplate.class, context -> factory.create());
        RestTemplate template = (RestTemplate)bootstrapContext.get(RestTemplate.class);
        factory.updateTemplate(template);
        bootstrapContext.addCloseListener(event -> event.getApplicationContext().getBeanFactory().registerSingleton("configClientRestTemplate", event.getBootstrapContext().get(RestTemplate.class)));
        return false;
    }

    public List<ConfigServerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        throw new IllegalStateException("Unexpected call. This resolver should not resolve any location");
    }

    public List<ConfigServerConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext context, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        throw new IllegalStateException("Unexpected call. This resolver should not resolve any location");
    }

    public int getOrder() {
        return -2;
    }

    private static class OAuth2ConfigClientRequestTemplateFactory
    extends ConfigClientRequestTemplateFactory {
        private ConfigClientProperties properties;
        private ConfigClientOAuth2Properties oAuth2Properties;

        public OAuth2ConfigClientRequestTemplateFactory(Log log, ConfigClientProperties clientProperties, ConfigClientOAuth2Properties oAuth2Properties) {
            super(log, clientProperties);
            this.properties = clientProperties;
            this.oAuth2Properties = oAuth2Properties;
        }

        public void update(ConfigClientProperties clientProperties, ConfigClientOAuth2Properties oAuth2Properties) {
            this.properties = clientProperties;
            this.oAuth2Properties = oAuth2Properties;
        }

        public ConfigClientProperties getProperties() {
            return this.properties;
        }

        public RestTemplate create() {
            if (this.properties.getRequestReadTimeout() < 0) {
                throw new IllegalStateException("Invalid Value for Read Timeout set.");
            }
            if (this.properties.getRequestConnectTimeout() < 0) {
                throw new IllegalStateException("Invalid Value for Connect Timeout set.");
            }
            return this.updateTemplate(new RestTemplate());
        }

        public void addAuthorizationToken(HttpHeaders httpHeaders, String username, String password) {
            String authorization = (String)this.properties.getHeaders().get("authorization");
            if (password != null && authorization != null) {
                throw new IllegalStateException("You must set either 'password' or 'authorization'");
            }
            if (password != null) {
                byte[] token = Base64.getEncoder().encode((username + ":" + password).getBytes());
                httpHeaders.add("Authorization", "Basic " + new String(token));
            } else if (authorization != null) {
                httpHeaders.add("Authorization", authorization);
            }
        }

        RestTemplate updateTemplate(RestTemplate template) {
            template.setRequestFactory(this.createHttpRequestFactory(this.properties));
            ArrayList<Object> interceptors = new ArrayList<Object>();
            HashMap headers = new HashMap(this.properties.getHeaders());
            headers.remove("authorization");
            if (!headers.isEmpty()) {
                interceptors.add(new ConfigClientRequestTemplateFactory.GenericRequestHeaderInterceptor(headers));
            }
            if (this.oAuth2Properties != null) {
                ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").clientId(this.oAuth2Properties.getClientId()).clientSecret(this.oAuth2Properties.getClientSecret()).tokenUri(this.oAuth2Properties.getAccessTokenUri()).scope(this.oAuth2Properties.getScope()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
                interceptors.add(new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration));
            }
            template.setInterceptors(interceptors);
            return template;
        }
    }
}

