/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingProperties;
import java.util.Map;

public class Recording {
    private Status status;
    private String id;
    private String sessionId;
    private long createdAt;
    private long size;
    private double duration;
    private String url;
    private RecordingProperties recordingProperties;

    protected Recording(JsonObject json) {
        this.id = json.get("id").getAsString();
        this.sessionId = json.get("sessionId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        this.size = json.get("size").getAsLong();
        this.duration = json.get("duration").getAsDouble();
        JsonElement urlElement = json.get("url");
        if (!urlElement.isJsonNull()) {
            this.url = urlElement.getAsString();
        }
        this.status = Status.valueOf(json.get("status").getAsString());
        RecordingProperties.Builder builder = RecordingProperties.fromJson((Map)new Gson().fromJson(json.toString(), Map.class), null);
        this.recordingProperties = builder.build();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.recordingProperties.name();
    }

    public boolean hasAudio() {
        return this.recordingProperties.hasAudio();
    }

    public boolean hasVideo() {
        return this.recordingProperties.hasVideo();
    }

    public OutputMode getOutputMode() {
        return this.recordingProperties.outputMode();
    }

    public RecordingLayout getRecordingLayout() {
        return this.recordingProperties.recordingLayout();
    }

    public String getCustomLayout() {
        return this.recordingProperties.customLayout();
    }

    public boolean ignoreFailedStreams() {
        return this.recordingProperties.ignoreFailedStreams();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getSize() {
        return this.size;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getUrl() {
        return this.url;
    }

    public String getResolution() {
        return this.recordingProperties.resolution();
    }

    public Integer getFrameRate() {
        return this.recordingProperties.frameRate();
    }

    public static enum OutputMode {
        COMPOSED,
        INDIVIDUAL,
        COMPOSED_QUICK_START;

    }

    public static enum Status {
        starting,
        started,
        stopped,
        ready,
        failed;

    }
}

