/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.openvidu.java.client.OpenViduException;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenVidu {
    private static final Logger log = LoggerFactory.getLogger(OpenVidu.class);
    protected String hostname;
    protected CloseableHttpClient httpClient;
    protected Map<String, Session> activeSessions = new ConcurrentHashMap<String, Session>();
    protected static final String API_PATH = "openvidu/api";
    protected static final String API_SESSIONS = "openvidu/api/sessions";
    protected static final String API_TOKENS = "openvidu/api/tokens";
    protected static final String API_RECORDINGS = "openvidu/api/recordings";
    protected static final String API_RECORDINGS_START = "openvidu/api/recordings/start";
    protected static final String API_RECORDINGS_STOP = "openvidu/api/recordings/stop";
    protected static final String API_BROADCAST = "openvidu/api/broadcast";
    protected static final String API_BROADCAST_START = "openvidu/api/broadcast/start";
    protected static final String API_BROADCAST_STOP = "openvidu/api/broadcast/stop";

    public OpenVidu(String hostname, String secret) {
        SSLContext sslContext;
        this.testHostname(hostname);
        this.hostname = hostname;
        if (!this.hostname.endsWith("/")) {
            this.hostname = this.hostname + "/";
        }
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials("OPENVIDUAPP", secret.toCharArray()));
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSslContext(sslContext).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setConnectionTimeToLive(TimeValue.ofSeconds((long)30L)).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30L, TimeUnit.SECONDS).setConnectionRequestTimeout(30L, TimeUnit.SECONDS).setResponseTimeout(30L, TimeUnit.SECONDS).build();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    public OpenVidu(String hostname, String secret, HttpClientBuilder builder) {
        this.testHostname(hostname);
        this.hostname = hostname;
        if (!this.hostname.endsWith("/")) {
            this.hostname = this.hostname + "/";
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials("OPENVIDUAPP", secret.toCharArray()));
        this.httpClient = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    public OpenVidu(String hostname, HttpClientBuilder builder) {
        this.testHostname(hostname);
        this.hostname = hostname;
        if (!this.hostname.endsWith("/")) {
            this.hostname = this.hostname + "/";
        }
        this.httpClient = builder.build();
    }

    public Session createSession() throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(this);
        this.activeSessions.put(s.getSessionId(), s);
        return s;
    }

    public Session createSession(SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(this, properties);
        this.activeSessions.put(s.getSessionId(), s);
        return s;
    }

    public Recording startRecording(String sessionId, RecordingProperties properties) throws OpenViduHttpException, OpenViduJavaClientException {
        HttpClientResponseHandler<Recording> responseHandler = new HttpClientResponseHandler<Recording>(){

            public Recording handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    Recording r = new Recording(OpenVidu.httpResponseEntityToJson(response.getEntity()));
                    Session activeSession = OpenVidu.this.activeSessions.get(r.getSessionId());
                    if (activeSession != null) {
                        activeSession.setIsBeingRecorded(true);
                    } else {
                        log.warn("No active session found for sessionId '{}'. This instance of OpenVidu Java Client didn't create this session", (Object)r.getSessionId());
                    }
                    return r;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        JsonObject json = properties.toJson();
        json.addProperty("session", sessionId);
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(this.hostname + API_RECORDINGS_START);
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            return (Recording)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public Recording startRecording(String sessionId, String name) throws OpenViduJavaClientException, OpenViduHttpException {
        if (name == null) {
            name = "";
        }
        return this.startRecording(sessionId, new RecordingProperties.Builder().name(name).build());
    }

    public Recording startRecording(String sessionId) throws OpenViduJavaClientException, OpenViduHttpException {
        return this.startRecording(sessionId, "");
    }

    public Recording stopRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Recording> responseHandler = new HttpClientResponseHandler<Recording>(){

            public Recording handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    Recording r = new Recording(OpenVidu.httpResponseEntityToJson(response.getEntity()));
                    Session activeSession = OpenVidu.this.activeSessions.get(r.getSessionId());
                    if (activeSession != null) {
                        activeSession.setIsBeingRecorded(false);
                    } else {
                        log.warn("No active session found for sessionId '{}'. This instance of OpenVidu Java Client didn't create this session", (Object)r.getSessionId());
                    }
                    return r;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        HttpPost request = new HttpPost(this.hostname + "openvidu/api/recordings/stop/" + recordingId);
        try {
            return (Recording)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public Recording getRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Recording> responseHandler = new HttpClientResponseHandler<Recording>(){

            public Recording handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    return new Recording(OpenVidu.httpResponseEntityToJson(response.getEntity()));
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        HttpGet request = new HttpGet(this.hostname + "openvidu/api/recordings/" + recordingId);
        try {
            return (Recording)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public List<Recording> listRecordings() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<List<Recording>> responseHandler = new HttpClientResponseHandler<List<Recording>>(){

            public List<Recording> handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    ArrayList<Recording> recordings = new ArrayList<Recording>();
                    JsonObject json = OpenVidu.httpResponseEntityToJson(response.getEntity());
                    JsonArray array = json.get("items").getAsJsonArray();
                    array.forEach(item -> recordings.add(new Recording(item.getAsJsonObject())));
                    return recordings;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        HttpGet request = new HttpGet(this.hostname + API_RECORDINGS);
        try {
            return (List)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public void deleteRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status != 204) {
                    throw OpenVidu.openViduHttpException(status);
                }
                return null;
            }
        };
        HttpDelete request = new HttpDelete(this.hostname + "openvidu/api/recordings/" + recordingId);
        try {
            this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public void startBroadcast(String sessionId, String broadcastUrl) throws OpenViduJavaClientException, OpenViduHttpException {
        this.startBroadcast(sessionId, broadcastUrl, new RecordingProperties.Builder().build());
    }

    public void startBroadcast(final String sessionId, String broadcastUrl, RecordingProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    Session activeSession = OpenVidu.this.activeSessions.get(sessionId);
                    if (activeSession != null) {
                        activeSession.setIsBeingBroadcasted(true);
                    } else {
                        log.warn("No active session found for sessionId '{}'. This instance of OpenVidu Java Client didn't create this session", (Object)sessionId);
                    }
                } else {
                    throw OpenVidu.openViduHttpException(status);
                }
                return null;
            }
        };
        JsonObject json = properties.toJson();
        json.addProperty("session", sessionId);
        json.addProperty("broadcastUrl", broadcastUrl);
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(this.hostname + API_BROADCAST_START);
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public void stopBroadcast(final String sessionId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    Session activeSession = OpenVidu.this.activeSessions.get(sessionId);
                    if (activeSession != null) {
                        activeSession.setIsBeingBroadcasted(false);
                    } else {
                        log.warn("No active session found for sessionId '{}'. This instance of OpenVidu Java Client didn't create this session", (Object)sessionId);
                    }
                    return null;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        JsonObject json = new JsonObject();
        json.addProperty("session", sessionId);
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(this.hostname + API_BROADCAST_STOP);
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public List<Session> getActiveSessions() {
        return new ArrayList<Session>(this.activeSessions.values());
    }

    public Session getActiveSession(String sessionId) {
        return this.activeSessions.get(sessionId);
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        final OpenVidu thisOV = this;
        HttpClientResponseHandler<Boolean> responseHandler = new HttpClientResponseHandler<Boolean>(){

            public Boolean handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    JsonObject jsonSessions = OpenVidu.httpResponseEntityToJson(response.getEntity());
                    JsonArray jsonArraySessions = jsonSessions.get("content").getAsJsonArray();
                    boolean[] hasChanged = new boolean[]{false};
                    HashSet fetchedSessionIds = new HashSet();
                    jsonArraySessions.forEach(sessionJsonElement -> {
                        JsonObject sessionJson = sessionJsonElement.getAsJsonObject();
                        Session sessionObj = new Session(thisOV, sessionJson);
                        String id = sessionObj.getSessionId();
                        fetchedSessionIds.add(id);
                        OpenVidu.this.activeSessions.computeIfPresent(id, (sId, s) -> {
                            String afterJSON;
                            String beforeJSON = s.toJson();
                            boolean changed = !beforeJSON.equals(afterJSON = (s = s.resetWithJson(sessionJson)).toJson());
                            hasChanged[0] = hasChanged[0] || changed;
                            log.info("Available session '{}' info fetched. Any change: {}", (Object)id, (Object)changed);
                            return s;
                        });
                        OpenVidu.this.activeSessions.computeIfAbsent(id, sId -> {
                            log.info("New session '{}' fetched", (Object)id);
                            hasChanged[0] = true;
                            return sessionObj;
                        });
                    });
                    OpenVidu.this.activeSessions.entrySet().removeIf(entry -> {
                        if (fetchedSessionIds.contains(entry.getKey())) {
                            return false;
                        }
                        log.info("Removing closed session {}", entry.getKey());
                        hasChanged[0] = true;
                        return true;
                    });
                    log.info("Active sessions info fetched: {}", OpenVidu.this.activeSessions.keySet());
                    return hasChanged[0];
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        HttpGet request = new HttpGet(this.hostname + "openvidu/api/sessions?pendingConnections=true");
        try {
            return (Boolean)this.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    protected static JsonObject httpResponseEntityToJson(HttpEntity responseEntity) throws IOException {
        try {
            JsonObject json = (JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8), JsonObject.class);
            return json;
        }
        catch (JsonSyntaxException | IOException | ParseException e) {
            JsonObject json = new JsonObject();
            json.addProperty("openviduExceptionType", OpenViduJavaClientException.class.getSimpleName());
            json.addProperty("openviduExceptionMessage", e.getMessage());
            throw new IOException(json.toString(), e.getCause());
        }
    }

    protected static IOException openViduHttpException(int status) {
        JsonObject json = new JsonObject();
        json.addProperty("openviduExceptionType", OpenViduHttpException.class.getSimpleName());
        json.addProperty("openviduExceptionMessage", (Number)status);
        return new IOException(json.toString());
    }

    protected static IOException openViduException(OpenViduException exception) {
        JsonObject json = new JsonObject();
        json.addProperty("openviduExceptionType", exception.getClass().getSimpleName());
        json.addProperty("openviduExceptionMessage", exception.getMessage());
        return new IOException(json.toString());
    }

    protected static OpenViduHttpException ioExceptionToOpenViduHttpException(IOException exception) throws OpenViduJavaClientException {
        JsonObject json;
        try {
            String message = exception.getMessage();
            json = JsonParser.parseString((String)message).getAsJsonObject();
        }
        catch (Exception e) {
            throw new OpenViduJavaClientException(exception.getMessage(), exception.getCause());
        }
        if (json.has("openviduExceptionType")) {
            String openviduExceptionType = json.get("openviduExceptionType").getAsString();
            if (OpenViduJavaClientException.class.getSimpleName().equals(openviduExceptionType)) {
                throw new OpenViduJavaClientException(json.get("openviduExceptionMessage").getAsString());
            }
            if (OpenViduHttpException.class.getSimpleName().equals(openviduExceptionType)) {
                return new OpenViduHttpException(json.get("openviduExceptionMessage").getAsInt());
            }
            log.error("Unknown OpenVidu Exception: " + openviduExceptionType);
            throw new OpenViduJavaClientException(exception.getMessage(), exception.getCause());
        }
        throw new OpenViduJavaClientException(exception.getMessage(), exception.getCause());
    }

    private void testHostname(String hostnameStr) {
        try {
            new URL(hostnameStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The hostname \"" + hostnameStr + "\" is not a valid URL: " + e.getMessage());
        }
    }
}

