/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;

public class KurentoOptions {
    private Integer videoMaxRecvBandwidth;
    private Integer videoMinRecvBandwidth;
    private Integer videoMaxSendBandwidth;
    private Integer videoMinSendBandwidth;
    private String[] allowedFilters;

    public KurentoOptions(Integer videoMaxRecvBandwidth, Integer videoMinRecvBandwidth, Integer videoMaxSendBandwidth, Integer videoMinSendBandwidth, String[] allowedFilters) {
        this.videoMaxRecvBandwidth = videoMaxRecvBandwidth;
        this.videoMinRecvBandwidth = videoMinRecvBandwidth;
        this.videoMaxSendBandwidth = videoMaxSendBandwidth;
        this.videoMinSendBandwidth = videoMinSendBandwidth;
        this.allowedFilters = allowedFilters;
    }

    public Integer getVideoMaxRecvBandwidth() {
        return this.videoMaxRecvBandwidth;
    }

    public Integer getVideoMinRecvBandwidth() {
        return this.videoMinRecvBandwidth;
    }

    public Integer getVideoMaxSendBandwidth() {
        return this.videoMaxSendBandwidth;
    }

    public Integer getVideoMinSendBandwidth() {
        return this.videoMinSendBandwidth;
    }

    public String[] getAllowedFilters() {
        return this.allowedFilters;
    }

    public boolean isFilterAllowed(String filterType) {
        if (filterType == null) {
            return false;
        }
        return Arrays.stream(this.allowedFilters).anyMatch(filterType::equals);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.getVideoMaxRecvBandwidth() != null) {
            json.addProperty("videoMaxRecvBandwidth", (Number)this.getVideoMaxRecvBandwidth());
        }
        if (this.getVideoMinRecvBandwidth() != null) {
            json.addProperty("videoMinRecvBandwidth", (Number)this.getVideoMinRecvBandwidth());
        }
        if (this.getVideoMaxSendBandwidth() != null) {
            json.addProperty("videoMaxSendBandwidth", (Number)this.getVideoMaxSendBandwidth());
        }
        if (this.getVideoMinSendBandwidth() != null) {
            json.addProperty("videoMinSendBandwidth", (Number)this.getVideoMinSendBandwidth());
        }
        if (this.getAllowedFilters().length > 0) {
            String[] filters;
            JsonArray filtersJson = new JsonArray();
            for (String filter : filters = this.getAllowedFilters()) {
                filtersJson.add(filter);
            }
            json.add("allowedFilters", (JsonElement)filtersJson);
        }
        return json;
    }

    public static class Builder {
        private Integer videoMaxRecvBandwidth;
        private Integer videoMinRecvBandwidth;
        private Integer videoMaxSendBandwidth;
        private Integer videoMinSendBandwidth;
        private String[] allowedFilters = new String[0];

        public KurentoOptions build() {
            return new KurentoOptions(this.videoMaxRecvBandwidth, this.videoMinRecvBandwidth, this.videoMaxSendBandwidth, this.videoMinSendBandwidth, this.allowedFilters);
        }

        public Builder videoMaxRecvBandwidth(int videoMaxRecvBandwidth) {
            this.videoMaxRecvBandwidth = videoMaxRecvBandwidth;
            return this;
        }

        public Builder videoMinRecvBandwidth(int videoMinRecvBandwidth) {
            this.videoMinRecvBandwidth = videoMinRecvBandwidth;
            return this;
        }

        public Builder videoMaxSendBandwidth(int videoMaxSendBandwidth) {
            this.videoMaxSendBandwidth = videoMaxSendBandwidth;
            return this;
        }

        public Builder videoMinSendBandwidth(int videoMinSendBandwidth) {
            this.videoMinSendBandwidth = videoMinSendBandwidth;
            return this;
        }

        public Builder allowedFilters(String[] allowedFilters) {
            this.allowedFilters = allowedFilters;
            return this;
        }
    }
}

