/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.openvidu.java.client.ConnectionType;
import io.openvidu.java.client.IceServerProperties;
import io.openvidu.java.client.KurentoOptions;
import io.openvidu.java.client.OpenViduRole;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionProperties {
    private ConnectionType type;
    private String data;
    private Boolean record;
    private OpenViduRole role;
    private KurentoOptions kurentoOptions;
    private String rtspUri;
    private Boolean adaptativeBitrate;
    private Boolean onlyPlayWithSubscribers;
    private Integer networkCache;
    private List<IceServerProperties> customIceServers;

    ConnectionProperties(ConnectionType type, String data, Boolean record, OpenViduRole role, KurentoOptions kurentoOptions, String rtspUri, Boolean adaptativeBitrate, Boolean onlyPlayWithSubscribers, Integer networkCache, List<IceServerProperties> customIceServers) {
        this.type = type;
        this.data = data;
        this.record = record;
        this.role = role;
        this.kurentoOptions = kurentoOptions;
        this.rtspUri = rtspUri;
        this.adaptativeBitrate = adaptativeBitrate;
        this.onlyPlayWithSubscribers = onlyPlayWithSubscribers;
        this.networkCache = networkCache;
        this.customIceServers = customIceServers;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public Boolean record() {
        return this.record;
    }

    public OpenViduRole getRole() {
        return this.role;
    }

    public KurentoOptions getKurentoOptions() {
        return this.kurentoOptions;
    }

    public String getRtspUri() {
        return this.rtspUri;
    }

    public Boolean adaptativeBitrate() {
        return this.adaptativeBitrate;
    }

    public Boolean onlyPlayWithSubscribers() {
        return this.onlyPlayWithSubscribers;
    }

    public Integer getNetworkCache() {
        return this.networkCache;
    }

    public List<IceServerProperties> getCustomIceServers() {
        return new ArrayList<IceServerProperties>(this.customIceServers);
    }

    public JsonObject toJson(String sessionId) {
        JsonObject json = new JsonObject();
        json.addProperty("session", sessionId);
        if (this.getType() != null) {
            json.addProperty("type", this.getType().name());
        } else {
            json.add("type", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getData() != null) {
            json.addProperty("data", this.getData());
        } else {
            json.add("data", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.record() != null) {
            json.addProperty("record", this.record());
        } else {
            json.add("record", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getRole() != null) {
            json.addProperty("role", this.getRole().name());
        } else {
            json.add("role", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.kurentoOptions != null) {
            json.add("kurentoOptions", (JsonElement)this.kurentoOptions.toJson());
        } else {
            json.add("kurentoOptions", (JsonElement)JsonNull.INSTANCE);
        }
        JsonArray customIceServersJsonList = new JsonArray();
        this.customIceServers.forEach(customIceServer -> customIceServersJsonList.add((JsonElement)customIceServer.toJson()));
        json.add("customIceServers", (JsonElement)customIceServersJsonList);
        if (this.getRtspUri() != null) {
            json.addProperty("rtspUri", this.getRtspUri());
        } else {
            json.add("rtspUri", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.adaptativeBitrate() != null) {
            json.addProperty("adaptativeBitrate", this.adaptativeBitrate());
        } else {
            json.add("adaptativeBitrate", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.onlyPlayWithSubscribers() != null) {
            json.addProperty("onlyPlayWithSubscribers", this.onlyPlayWithSubscribers());
        } else {
            json.add("onlyPlayWithSubscribers", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getNetworkCache() != null) {
            json.addProperty("networkCache", (Number)this.getNetworkCache());
        } else {
            json.add("networkCache", (JsonElement)JsonNull.INSTANCE);
        }
        return json;
    }

    public static Builder fromJson(Map<String, ?> params) throws IllegalArgumentException {
        Boolean record;
        ConnectionType type;
        String data;
        String typeString;
        Builder builder = new Builder();
        if (params == null) {
            params = new HashMap();
        }
        try {
            typeString = (String)params.get("type");
            data = (String)params.get("data");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Type error in some parameter: " + e.getMessage());
        }
        try {
            type = typeString != null ? ConnectionType.valueOf(typeString) : DefaultValues.type;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Parameter 'type' " + typeString + " is not defined");
        }
        data = data != null ? data : "";
        builder.type(type).data(data).record(true);
        OpenViduRole role = null;
        KurentoOptions kurentoOptions = null;
        if (ConnectionType.WEBRTC.equals((Object)type)) {
            String roleString;
            try {
                roleString = (String)params.get("role");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Type error in parameter 'role': " + e.getMessage());
            }
            try {
                role = roleString != null ? OpenViduRole.valueOf(roleString) : DefaultValues.role;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Parameter role " + params.get("role") + " is not defined");
            }
            JsonObject kurentoOptionsJson = null;
            if (params.get("kurentoOptions") != null) {
                try {
                    kurentoOptionsJson = new Gson().toJsonTree(params.get("kurentoOptions"), Map.class).getAsJsonObject();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error in parameter 'kurentoOptions'. It is not a valid JSON object");
                }
            }
            if (kurentoOptionsJson != null) {
                try {
                    KurentoOptions.Builder builder2 = new KurentoOptions.Builder();
                    if (kurentoOptionsJson.has("videoMaxRecvBandwidth")) {
                        builder2.videoMaxRecvBandwidth(kurentoOptionsJson.get("videoMaxRecvBandwidth").getAsInt());
                    }
                    if (kurentoOptionsJson.has("videoMinRecvBandwidth")) {
                        builder2.videoMinRecvBandwidth(kurentoOptionsJson.get("videoMinRecvBandwidth").getAsInt());
                    }
                    if (kurentoOptionsJson.has("videoMaxSendBandwidth")) {
                        builder2.videoMaxSendBandwidth(kurentoOptionsJson.get("videoMaxSendBandwidth").getAsInt());
                    }
                    if (kurentoOptionsJson.has("videoMinSendBandwidth")) {
                        builder2.videoMinSendBandwidth(kurentoOptionsJson.get("videoMinSendBandwidth").getAsInt());
                    }
                    if (kurentoOptionsJson.has("allowedFilters")) {
                        JsonArray filters = kurentoOptionsJson.get("allowedFilters").getAsJsonArray();
                        String[] arrayOfFilters = new String[filters.size()];
                        Iterator it = filters.iterator();
                        int index = 0;
                        while (it.hasNext()) {
                            arrayOfFilters[index] = ((JsonElement)it.next()).getAsString();
                            ++index;
                        }
                        builder2.allowedFilters(arrayOfFilters);
                    }
                    kurentoOptions = builder2.build();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Type error in some parameter of 'kurentoOptions': " + e.getMessage());
                }
            }
            JsonArray customIceServersJsonArray = null;
            if (params.get("customIceServers") != null) {
                try {
                    customIceServersJsonArray = new Gson().toJsonTree(params.get("customIceServers"), List.class).getAsJsonArray();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error in parameter 'customIceServersJson'. It is not a valid JSON object");
                }
            }
            if (customIceServersJsonArray != null) {
                try {
                    for (int i = 0; i < customIceServersJsonArray.size(); ++i) {
                        JsonObject customIceServerJson = customIceServersJsonArray.get(i).getAsJsonObject();
                        IceServerProperties.Builder iceServerPropertiesBuilder = new IceServerProperties.Builder();
                        iceServerPropertiesBuilder.url(customIceServerJson.get("url").getAsString());
                        if (customIceServerJson.has("staticAuthSecret")) {
                            iceServerPropertiesBuilder.staticAuthSecret(customIceServerJson.get("staticAuthSecret").getAsString());
                        }
                        if (customIceServerJson.has("username")) {
                            iceServerPropertiesBuilder.username(customIceServerJson.get("username").getAsString());
                        }
                        if (customIceServerJson.has("credential")) {
                            iceServerPropertiesBuilder.credential(customIceServerJson.get("credential").getAsString());
                        }
                        IceServerProperties iceServerProperties = iceServerPropertiesBuilder.build();
                        builder.addCustomIceServer(iceServerProperties);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Type error in some parameter of 'customIceServers': " + e.getMessage());
                }
            }
            builder.role(role).kurentoOptions(kurentoOptions);
        } else if (ConnectionType.IPCAM.equals((Object)type)) {
            Number networkCache;
            Boolean onlyPlayWithSubscribers;
            Boolean adaptativeBitrate;
            String rtspUri;
            try {
                rtspUri = (String)params.get("rtspUri");
                adaptativeBitrate = (Boolean)params.get("adaptativeBitrate");
                onlyPlayWithSubscribers = (Boolean)params.get("onlyPlayWithSubscribers");
                networkCache = (Number)params.get("networkCache");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Type error in some parameter: " + e.getMessage());
            }
            adaptativeBitrate = adaptativeBitrate != null ? adaptativeBitrate : DefaultValues.adaptativeBitrate;
            onlyPlayWithSubscribers = onlyPlayWithSubscribers != null ? onlyPlayWithSubscribers : DefaultValues.onlyPlayWithSubscribers;
            Number number = networkCache = networkCache != null ? (Number)networkCache : (Number)DefaultValues.networkCache;
            if (rtspUri != null) {
                try {
                    ConnectionProperties.checkRtspUri(rtspUri);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Error in parameter 'rtspUri': " + e.getMessage());
                }
            }
            try {
                builder.rtspUri(rtspUri).adaptativeBitrate(adaptativeBitrate).onlyPlayWithSubscribers(onlyPlayWithSubscribers).networkCache(networkCache.intValue()).build();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Type error in some parameter: " + e.getMessage());
            }
        }
        try {
            record = (Boolean)params.get("record");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Type error in parameter 'record': " + e.getMessage());
        }
        record = record != null ? record : DefaultValues.record;
        builder.record(record);
        return builder;
    }

    public static URI checkRtspUri(String rtspUri) throws MalformedURLException {
        try {
            URI uri = new URI(rtspUri);
            List<String> allowedSchemes = Arrays.asList("file", "rtsp", "rtsps", "http", "https");
            if (!allowedSchemes.contains(uri.getScheme())) {
                throw new MalformedURLException("RTSP URI does not contain a valid protocol " + allowedSchemes.toString());
            }
            return uri;
        }
        catch (Exception e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public static class Builder {
        private ConnectionType type;
        private String data;
        private Boolean record;
        private OpenViduRole role;
        private KurentoOptions kurentoOptions;
        private List<IceServerProperties> customIceServers = new ArrayList<IceServerProperties>();
        private String rtspUri;
        private Boolean adaptativeBitrate;
        private Boolean onlyPlayWithSubscribers;
        private Integer networkCache;

        public ConnectionProperties build() {
            return new ConnectionProperties(this.type, this.data, this.record, this.role, this.kurentoOptions, this.rtspUri, this.adaptativeBitrate, this.onlyPlayWithSubscribers, this.networkCache, this.customIceServers);
        }

        public Builder type(ConnectionType type) {
            this.type = type;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder record(boolean record) {
            this.record = record;
            return this;
        }

        public Builder role(OpenViduRole role) {
            this.role = role;
            return this;
        }

        public Builder kurentoOptions(KurentoOptions kurentoOptions) {
            this.kurentoOptions = kurentoOptions;
            return this;
        }

        public Builder rtspUri(String rtspUri) throws MalformedURLException {
            ConnectionProperties.checkRtspUri(rtspUri);
            this.rtspUri = rtspUri;
            return this;
        }

        public Builder adaptativeBitrate(boolean adaptativeBitrate) {
            this.adaptativeBitrate = adaptativeBitrate;
            return this;
        }

        public Builder onlyPlayWithSubscribers(boolean onlyPlayWithSubscribers) {
            this.onlyPlayWithSubscribers = onlyPlayWithSubscribers;
            return this;
        }

        public Builder networkCache(int networkCache) {
            this.networkCache = networkCache;
            return this;
        }

        public Builder addCustomIceServer(IceServerProperties iceServerProperties) {
            this.customIceServers.add(iceServerProperties);
            return this;
        }
    }

    public static class DefaultValues {
        public static final ConnectionType type = ConnectionType.WEBRTC;
        public static final String data = "";
        public static final Boolean record = true;
        public static final OpenViduRole role = OpenViduRole.PUBLISHER;
        public static final KurentoOptions kurentoOptions = null;
        public static final String rtspUri = null;
        public static final Boolean adaptativeBitrate = true;
        public static final Boolean onlyPlayWithSubscribers = true;
        public static final Integer networkCache = 2000;
        public static final List<IceServerProperties> customIceServers = null;
    }
}

