/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.openvidu.java.client.ConnectionProperties;
import io.openvidu.java.client.ConnectionType;
import io.openvidu.java.client.IceServerProperties;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Publisher;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Connection {
    private String connectionId;
    private String status;
    private Long createdAt;
    private Long activeAt;
    private String location;
    private String ip;
    private String platform;
    private String clientData;
    private ConnectionProperties connectionProperties;
    private String token;
    protected Map<String, Publisher> publishers = new ConcurrentHashMap<String, Publisher>();
    protected List<String> subscribers = new ArrayList<String>();

    protected Connection(JsonObject json) {
        this.resetWithJson(json);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getStatus() {
        return this.status;
    }

    public Long createdAt() {
        return this.createdAt;
    }

    public Long activeAt() {
        return this.activeAt;
    }

    public ConnectionType getType() {
        return this.connectionProperties.getType();
    }

    public String getServerData() {
        return this.connectionProperties.getData();
    }

    public boolean record() {
        return this.connectionProperties.record();
    }

    public OpenViduRole getRole() {
        return this.connectionProperties.getRole();
    }

    public String getRtspUri() {
        return this.connectionProperties.getRtspUri();
    }

    public Boolean adaptativeBitrate() {
        return this.connectionProperties.adaptativeBitrate();
    }

    public Boolean onlyPlayWithSubscribers() {
        return this.connectionProperties.onlyPlayWithSubscribers();
    }

    public Integer getNetworkCache() {
        return this.connectionProperties.getNetworkCache();
    }

    public List<IceServerProperties> getCustomIceServers() {
        return this.connectionProperties.getCustomIceServers();
    }

    public String getToken() {
        return this.token;
    }

    public String getLocation() {
        return this.location;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getClientData() {
        return this.clientData;
    }

    public List<Publisher> getPublishers() {
        return new ArrayList<Publisher>(this.publishers.values());
    }

    public List<String> getSubscribers() {
        return this.subscribers;
    }

    protected JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("connectionId", this.getConnectionId());
        json.addProperty("status", this.getStatus());
        json.addProperty("createdAt", (Number)this.createdAt());
        json.addProperty("activeAt", (Number)this.activeAt());
        json.addProperty("location", this.getLocation());
        json.addProperty("ip", this.getIp());
        json.addProperty("platform", this.getPlatform());
        json.addProperty("clientData", this.getClientData());
        json.addProperty("token", this.getToken());
        JsonObject jsonConnectionProperties = this.connectionProperties.toJson("");
        jsonConnectionProperties.remove("session");
        json.addProperty("serverData", jsonConnectionProperties.get("data").getAsString());
        jsonConnectionProperties.remove("data");
        jsonConnectionProperties.entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        JsonArray pubs = new JsonArray();
        this.getPublishers().forEach(p -> pubs.add((JsonElement)p.toJson()));
        JsonArray subs = new JsonArray();
        this.getSubscribers().forEach(s -> subs.add(s));
        json.add("publishers", (JsonElement)pubs);
        json.add("subscribers", (JsonElement)subs);
        return json;
    }

    protected void overrideConnectionProperties(ConnectionProperties newConnectionProperties) {
        ConnectionProperties.Builder builder = new ConnectionProperties.Builder();
        if (newConnectionProperties.getRole() != null) {
            builder.role(newConnectionProperties.getRole());
        } else {
            builder.role(this.connectionProperties.getRole());
        }
        if (newConnectionProperties.record() != null) {
            builder.record(newConnectionProperties.record());
        } else {
            builder.record(this.connectionProperties.record());
        }
        try {
            builder.type(this.connectionProperties.getType()).data(this.connectionProperties.getData()).kurentoOptions(this.connectionProperties.getKurentoOptions()).rtspUri(this.connectionProperties.getRtspUri());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.connectionProperties.adaptativeBitrate() != null) {
            builder.adaptativeBitrate(this.connectionProperties.adaptativeBitrate());
        }
        if (this.connectionProperties.onlyPlayWithSubscribers() != null) {
            builder.onlyPlayWithSubscribers(this.connectionProperties.onlyPlayWithSubscribers());
        }
        if (this.connectionProperties.getNetworkCache() != null) {
            builder.networkCache(this.connectionProperties.getNetworkCache());
        }
        if (this.connectionProperties.getCustomIceServers() != null && !this.connectionProperties.getCustomIceServers().isEmpty()) {
            for (IceServerProperties iceServerProperties : this.connectionProperties.getCustomIceServers()) {
                builder.addCustomIceServer(iceServerProperties);
            }
        }
        this.connectionProperties = builder.build();
    }

    protected void setSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
    }

    protected Connection resetWithJson(JsonObject json) {
        this.connectionId = json.get("connectionId").getAsString();
        this.status = json.get("status").getAsString();
        String string = this.token = !json.get("token").isJsonNull() ? json.get("token").getAsString() : null;
        if (!json.get("publishers").isJsonNull()) {
            JsonArray jsonArrayPublishers = json.get("publishers").getAsJsonArray();
            HashSet fetchedPublisherIds = new HashSet();
            jsonArrayPublishers.forEach(publisherJsonElement -> {
                JsonObject publisherJson = publisherJsonElement.getAsJsonObject();
                Publisher publisherObj = new Publisher(publisherJson);
                String id = publisherObj.getStreamId();
                fetchedPublisherIds.add(id);
                this.publishers.computeIfPresent(id, (pId, p) -> {
                    p = p.resetWithJson(publisherJson);
                    return p;
                });
                this.publishers.computeIfAbsent(id, pId -> publisherObj);
            });
            this.publishers.entrySet().removeIf(entry -> !fetchedPublisherIds.contains(((Publisher)entry.getValue()).getStreamId()));
        }
        if (!json.get("subscribers").isJsonNull()) {
            JsonArray jsonArraySubscribers = json.get("subscribers").getAsJsonArray();
            HashSet fetchedSubscriberIds = new HashSet();
            jsonArraySubscribers.forEach(subscriber -> {
                String sub = subscriber.getAsJsonObject().get("streamId").getAsString();
                fetchedSubscriberIds.add(sub);
                if (!this.subscribers.contains(sub)) {
                    this.subscribers.add(sub);
                }
            });
            this.subscribers.removeIf(subId -> !fetchedSubscriberIds.contains(subId));
        }
        if (!json.get("createdAt").isJsonNull()) {
            this.createdAt = json.get("createdAt").getAsLong();
        }
        if (!json.get("activeAt").isJsonNull()) {
            this.activeAt = json.get("activeAt").getAsLong();
        }
        if (!json.get("location").isJsonNull()) {
            this.location = json.get("location").getAsString();
        }
        if (!json.get("ip").isJsonNull()) {
            this.ip = json.get("ip").getAsString();
        }
        if (!json.get("platform").isJsonNull()) {
            this.platform = json.get("platform").getAsString();
        }
        if (!json.get("clientData").isJsonNull()) {
            this.clientData = json.get("clientData").getAsString();
        }
        ConnectionType type = ConnectionType.valueOf(json.get("type").getAsString());
        String data = json.has("serverData") && !json.get("serverData").isJsonNull() ? json.get("serverData").getAsString() : null;
        Boolean record = json.has("record") && !json.get("record").isJsonNull() ? Boolean.valueOf(json.get("record").getAsBoolean()) : null;
        OpenViduRole role = json.has("role") && !json.get("role").isJsonNull() ? OpenViduRole.valueOf(json.get("role").getAsString()) : null;
        ArrayList<IceServerProperties> customIceServers = new ArrayList<IceServerProperties>();
        if (json.has("customIceServers") && json.get("customIceServers").isJsonArray()) {
            JsonArray customIceServersJsonArray = json.get("customIceServers").getAsJsonArray();
            customIceServersJsonArray.forEach(iceJsonElem -> {
                JsonObject iceJsonObj = iceJsonElem.getAsJsonObject();
                String url = iceJsonObj.has("url") && !iceJsonObj.get("url").isJsonNull() ? iceJsonObj.get("url").getAsString() : null;
                String username = iceJsonObj.has("username") && !iceJsonObj.get("username").isJsonNull() ? iceJsonObj.get("username").getAsString() : null;
                String credential = iceJsonObj.has("credential") && !iceJsonObj.get("credential").isJsonNull() ? iceJsonObj.get("credential").getAsString() : null;
                customIceServers.add(new IceServerProperties.Builder().url(url).username(username).credential(credential).build());
            });
        }
        String rtspUri = json.has("rtspUri") && !json.get("rtspUri").isJsonNull() ? json.get("rtspUri").getAsString() : null;
        Boolean adaptativeBitrate = json.has("adaptativeBitrate") && !json.get("adaptativeBitrate").isJsonNull() ? Boolean.valueOf(json.get("adaptativeBitrate").getAsBoolean()) : null;
        Boolean onlyPlayWithSubscribers = json.has("onlyPlayWithSubscribers") && !json.get("onlyPlayWithSubscribers").isJsonNull() ? Boolean.valueOf(json.get("onlyPlayWithSubscribers").getAsBoolean()) : null;
        Integer networkCache = json.has("networkCache") && !json.get("networkCache").isJsonNull() ? Integer.valueOf(json.get("networkCache").getAsInt()) : null;
        this.connectionProperties = new ConnectionProperties(type, data, record, role, null, rtspUri, adaptativeBitrate, onlyPlayWithSubscribers, networkCache, customIceServers);
        return this;
    }
}

