/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms2;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.SpanJmsDecorator;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public class TracingJMSProducer
implements JMSProducer {
    private final JMSProducer jmsProducer;
    private JMSContext jmsContext = null;
    private Session jmsSession = null;
    private final Tracer tracer;

    public TracingJMSProducer(JMSProducer jmsProducer, JMSContext jmsContext, Tracer tracer) {
        this.jmsProducer = jmsProducer;
        this.jmsContext = jmsContext;
        this.tracer = tracer;
    }

    public TracingJMSProducer(JMSProducer jmsProducer, Session jmsSession, Tracer tracer) {
        this.jmsProducer = jmsProducer;
        this.jmsSession = jmsSession;
        this.tracer = tracer;
    }

    public JMSProducer clearProperties() {
        this.jmsProducer.clearProperties();
        return this;
    }

    public CompletionListener getAsync() {
        return this.jmsProducer.getAsync();
    }

    public boolean getBooleanProperty(String arg0) {
        return this.jmsProducer.getBooleanProperty(arg0);
    }

    public byte getByteProperty(String arg0) {
        return this.jmsProducer.getByteProperty(arg0);
    }

    public long getDeliveryDelay() {
        return this.jmsProducer.getDeliveryDelay();
    }

    public int getDeliveryMode() {
        return this.jmsProducer.getDeliveryMode();
    }

    public boolean getDisableMessageID() {
        return this.jmsProducer.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() {
        return this.jmsProducer.getDisableMessageTimestamp();
    }

    public double getDoubleProperty(String arg0) {
        return this.jmsProducer.getDoubleProperty(arg0);
    }

    public float getFloatProperty(String arg0) {
        return this.jmsProducer.getFloatProperty(arg0);
    }

    public int getIntProperty(String arg0) {
        return this.jmsProducer.getIntProperty(arg0);
    }

    public String getJMSCorrelationID() {
        return this.jmsProducer.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.jmsProducer.getJMSCorrelationIDAsBytes();
    }

    public Destination getJMSReplyTo() {
        return this.jmsProducer.getJMSReplyTo();
    }

    public String getJMSType() {
        return this.jmsProducer.getJMSType();
    }

    public long getLongProperty(String arg0) {
        return this.jmsProducer.getLongProperty(arg0);
    }

    public Object getObjectProperty(String arg0) {
        return this.jmsProducer.getObjectProperty(arg0);
    }

    public int getPriority() {
        return this.jmsProducer.getPriority();
    }

    public Set<String> getPropertyNames() {
        return this.jmsProducer.getPropertyNames();
    }

    public short getShortProperty(String arg0) {
        return this.jmsProducer.getShortProperty(arg0);
    }

    public String getStringProperty(String arg0) {
        return this.jmsProducer.getStringProperty(arg0);
    }

    public long getTimeToLive() {
        return this.jmsProducer.getTimeToLive();
    }

    public boolean propertyExists(String arg0) {
        return this.jmsProducer.propertyExists(arg0);
    }

    public JMSProducer send(Destination destination, Message message) {
        Span span = TracingMessageUtils.buildAndInjectSpan((Destination)destination, (Message)message, (Tracer)this.tracer);
        try {
            this.jmsProducer.send(destination, message);
        }
        catch (Throwable e) {
            SpanJmsDecorator.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
        return this;
    }

    public JMSProducer send(Destination destination, String message) {
        TextMessage textMsg;
        try {
            textMsg = this.getTextMessage();
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.jmsProducer.send(destination, message);
            return this;
        }
        if (textMsg == null) {
            this.jmsProducer.send(destination, message);
            return this;
        }
        try {
            textMsg.setText(message);
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.jmsProducer.send(destination, message);
            return this;
        }
        return this.send(destination, (Message)textMsg);
    }

    private TextMessage getTextMessage() throws JMSException {
        TextMessage textMsg = null;
        if (this.jmsContext != null) {
            textMsg = this.jmsContext.createTextMessage();
        } else if (this.jmsSession != null) {
            textMsg = this.jmsSession.createTextMessage();
        }
        return textMsg;
    }

    public JMSProducer send(Destination destination, Map<String, Object> arg1) {
        MapMessage mapMsg;
        try {
            mapMsg = this.getMapMessage();
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.jmsProducer.send(destination, arg1);
            return this;
        }
        if (mapMsg == null) {
            this.jmsProducer.send(destination, arg1);
            return this;
        }
        for (Map.Entry<String, Object> entry : arg1.entrySet()) {
            try {
                mapMsg.setObject(entry.getKey(), entry.getValue());
            }
            catch (JMSException e) {
                e.printStackTrace();
                this.jmsProducer.send(destination, arg1);
                return this;
            }
        }
        return this.send(destination, (Message)mapMsg);
    }

    private MapMessage getMapMessage() throws JMSException {
        MapMessage mapMsg = null;
        if (this.jmsContext != null) {
            mapMsg = this.jmsContext.createMapMessage();
        } else if (this.jmsSession != null) {
            mapMsg = this.jmsSession.createMapMessage();
        }
        return mapMsg;
    }

    public JMSProducer send(Destination destination, byte[] arg1) {
        BytesMessage bytesMsg;
        try {
            bytesMsg = this.getBytesMessage();
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.jmsProducer.send(destination, arg1);
            return this;
        }
        if (bytesMsg == null) {
            this.jmsProducer.send(destination, arg1);
            return this;
        }
        try {
            bytesMsg.writeBytes(arg1);
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.jmsProducer.send(destination, arg1);
            return this;
        }
        return this.send(destination, (Message)bytesMsg);
    }

    private BytesMessage getBytesMessage() throws JMSException {
        BytesMessage bytesMsg = null;
        if (this.jmsContext != null) {
            bytesMsg = this.jmsContext.createBytesMessage();
        } else if (this.jmsSession != null) {
            bytesMsg = this.jmsSession.createBytesMessage();
        }
        return bytesMsg;
    }

    public JMSProducer send(Destination destination, Serializable obj) {
        Message message;
        try {
            message = this.createJMSMessage(obj);
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.jmsProducer.send(destination, obj);
            return this;
        }
        if (message == null) {
            this.jmsProducer.send(destination, obj);
            return this;
        }
        return this.send(destination, message);
    }

    private Message createJMSMessage(Serializable obj) throws JMSException {
        if (obj instanceof String) {
            TextMessage textMsg = this.getTextMessage();
            if (textMsg == null) {
                return null;
            }
            textMsg.setText((String)((Object)obj));
            return textMsg;
        }
        ObjectMessage objMsg = this.getObjectMessage();
        if (objMsg == null) {
            return null;
        }
        objMsg.setObject(obj);
        return objMsg;
    }

    private ObjectMessage getObjectMessage() throws JMSException {
        ObjectMessage objectMsg = null;
        if (this.jmsContext != null) {
            objectMsg = this.jmsContext.createObjectMessage();
        } else if (this.jmsSession != null) {
            objectMsg = this.jmsSession.createObjectMessage();
        }
        return objectMsg;
    }

    public JMSProducer setAsync(CompletionListener arg0) {
        this.jmsProducer.setAsync(arg0);
        return this;
    }

    public JMSProducer setDeliveryDelay(long arg0) {
        this.jmsProducer.setDeliveryDelay(arg0);
        return this;
    }

    public JMSProducer setDeliveryMode(int arg0) {
        this.jmsProducer.setDeliveryMode(arg0);
        return this;
    }

    public JMSProducer setDisableMessageID(boolean arg0) {
        this.jmsProducer.setDisableMessageID(arg0);
        return this;
    }

    public JMSProducer setDisableMessageTimestamp(boolean arg0) {
        this.jmsProducer.setDisableMessageTimestamp(arg0);
        return this;
    }

    public JMSProducer setJMSCorrelationID(String arg0) {
        this.jmsProducer.setJMSCorrelationID(arg0);
        return this;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] arg0) {
        this.jmsProducer.setJMSCorrelationIDAsBytes(arg0);
        return this;
    }

    public JMSProducer setJMSReplyTo(Destination destination) {
        this.jmsProducer.setJMSReplyTo(destination);
        return this;
    }

    public JMSProducer setJMSType(String arg0) {
        this.jmsProducer.setJMSType(arg0);
        return this;
    }

    public JMSProducer setPriority(int arg0) {
        this.jmsProducer.setPriority(arg0);
        return this;
    }

    public JMSProducer setProperty(String arg0, boolean arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, byte arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, short arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, int arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, long arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, float arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, double arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, String arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setProperty(String arg0, Object arg1) {
        this.jmsProducer.setProperty(arg0, arg1);
        return this;
    }

    public JMSProducer setTimeToLive(long arg0) {
        this.jmsProducer.setTimeToLive(arg0);
        return this;
    }
}

