/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms2;

import io.opentracing.Span;
import io.opentracing.contrib.jms.common.SpanJmsDecorator;
import javax.jms.CompletionListener;
import javax.jms.Message;

public class TracingCompletionListener
implements CompletionListener {
    private final Span span;
    private final CompletionListener completionListener;

    public TracingCompletionListener(Span span, CompletionListener completionListener) {
        this.span = span;
        this.completionListener = completionListener;
    }

    public void onCompletion(Message message) {
        try {
            this.completionListener.onCompletion(message);
        }
        finally {
            this.span.finish();
        }
    }

    public void onException(Message message, Exception exception) {
        try {
            this.completionListener.onException(message, exception);
        }
        finally {
            SpanJmsDecorator.onError((Throwable)exception, (Span)this.span);
            this.span.finish();
        }
    }
}

