/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.AbstractURLParser;
import io.opentracing.contrib.jdbc.parser.URLLocation;

public class PostgreSQLURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 5432;
    private static final String DB_TYPE = "postgresql";

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange(String url) {
        int hostLabelStartIndex = url.indexOf("//");
        int hostLabelEndIndex = url.indexOf("/", hostLabelStartIndex + 2);
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange(String url) {
        int databaseStartTag = url.lastIndexOf("/");
        int databaseEndTag = url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse(String url) {
        URLLocation location = this.fetchDatabaseHostsIndexRange(url);
        String hosts = url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.split(":").length == 1) {
                    sb.append(host + ":" + 5432 + ",");
                    continue;
                }
                sb.append(host + ",");
            }
            return new ConnectionInfo.Builder(sb.toString()).dbType(DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
        }
        String[] hostAndPort = hostSegment[0].split(":");
        if (hostAndPort.length != 1) {
            return new ConnectionInfo.Builder(hostAndPort[0], Integer.valueOf(hostAndPort[1])).dbType(DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
        }
        return new ConnectionInfo.Builder(hostAndPort[0], 5432).dbType(DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
    }
}

