/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.LongCounter;
import io.opentelemetry.metrics.Meter;
import io.opentelemetry.sdk.common.DaemonThreadFactory;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.AutoValue_BatchSpansProcessor_Config;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;

public final class BatchSpansProcessor
implements SpanProcessor {
    private static final String WORKER_THREAD_NAME = BatchSpansProcessor.class.getSimpleName() + "_WorkerThread";
    private static final String EXPORTER_THREAD_NAME = BatchSpansProcessor.class.getSimpleName() + "_ExporterThread";
    private final Worker worker;
    private final Thread workerThread;
    private final boolean sampled;

    private BatchSpansProcessor(SpanExporter spanExporter, boolean sampled, long scheduleDelayMillis, int maxQueueSize, int maxExportBatchSize, int exporterTimeoutMillis) {
        this.worker = new Worker(spanExporter, scheduleDelayMillis, maxQueueSize, maxExportBatchSize, exporterTimeoutMillis);
        this.workerThread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        this.workerThread.start();
        this.sampled = sampled;
    }

    public static BatchSpansProcessor create(SpanExporter spanExporter) {
        return BatchSpansProcessor.create(spanExporter, Config.getDefault());
    }

    public static BatchSpansProcessor create(SpanExporter spanExporter, Config config) {
        return new BatchSpansProcessor(spanExporter, config.isExportOnlySampled(), config.getScheduleDelayMillis(), config.getMaxQueueSize(), config.getMaxExportBatchSize(), config.getExporterTimeoutMillis());
    }

    @Override
    public void onStart(ReadableSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().getTraceFlags().isSampled()) {
            return;
        }
        this.worker.addSpan(span);
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public void shutdown() {
        this.workerThread.interrupt();
        this.worker.shutdown();
    }

    @Override
    public void forceFlush() {
        this.worker.forceFlush();
    }

    static /* synthetic */ String access$400() {
        return EXPORTER_THREAD_NAME;
    }

    @Immutable
    @AutoValue
    public static abstract class Config {
        private static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 5000L;
        private static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
        private static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
        private static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
        private static final boolean DEFAULT_EXPORT_ONLY_SAMPLED = true;

        public abstract boolean isExportOnlySampled();

        public abstract long getScheduleDelayMillis();

        public abstract int getMaxQueueSize();

        public abstract int getMaxExportBatchSize();

        public abstract int getExporterTimeoutMillis();

        public static Config getDefault() {
            return Config.newBuilder().build();
        }

        public static Config loadFromDefaultSources() {
            return Config.newBuilder().readEnvironment().readSystemProperties().build();
        }

        public static Builder newBuilder() {
            return new AutoValue_BatchSpansProcessor_Config.Builder().setScheduleDelayMillis(5000L).setMaxQueueSize(2048).setMaxExportBatchSize(512).setExporterTimeoutMillis(30000).setExportOnlySampled(true);
        }

        @AutoValue.Builder
        public static abstract class Builder
        extends ConfigBuilder<Builder> {
            private static final String KEY_SCHEDULE_DELAY_MILLIS = "otel.bsp.schedule.delay";
            private static final String KEY_MAX_QUEUE_SIZE = "otel.bsp.max.queue";
            private static final String KEY_MAX_EXPORT_BATCH_SIZE = "otel.bsp.max.export.batch";
            private static final String KEY_EXPORT_TIMEOUT_MILLIS = "otel.bsp.export.timeout";
            private static final String KEY_SAMPLED = "otel.bsp.export.sampled";

            @Override
            @VisibleForTesting
            protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
                Boolean boolValue;
                Integer intValue;
                Long longValue = Builder.getLongProperty(KEY_SCHEDULE_DELAY_MILLIS, configMap = namingConvention.normalize(configMap));
                if (longValue != null) {
                    this.setScheduleDelayMillis(longValue);
                }
                if ((intValue = Builder.getIntProperty(KEY_MAX_QUEUE_SIZE, configMap)) != null) {
                    this.setMaxQueueSize(intValue);
                }
                if ((intValue = Builder.getIntProperty(KEY_MAX_EXPORT_BATCH_SIZE, configMap)) != null) {
                    this.setMaxExportBatchSize(intValue);
                }
                if ((intValue = Builder.getIntProperty(KEY_EXPORT_TIMEOUT_MILLIS, configMap)) != null) {
                    this.setExporterTimeoutMillis(intValue);
                }
                if ((boolValue = Builder.getBooleanProperty(KEY_SAMPLED, configMap)) != null) {
                    this.setExportOnlySampled(boolValue);
                }
                return this;
            }

            @Override
            public Builder readProperties(Properties properties) {
                return (Builder)super.readProperties(properties);
            }

            @Override
            public Builder readEnvironment() {
                return (Builder)super.readEnvironment();
            }

            @Override
            public Builder readSystemProperties() {
                return (Builder)super.readSystemProperties();
            }

            public abstract Builder setExportOnlySampled(boolean var1);

            public abstract Builder setScheduleDelayMillis(long var1);

            public abstract Builder setExporterTimeoutMillis(int var1);

            public abstract Builder setMaxQueueSize(int var1);

            public abstract Builder setMaxExportBatchSize(int var1);

            abstract Config autoBuild();

            public Config build() {
                Config config = this.autoBuild();
                Utils.checkArgument((config.getScheduleDelayMillis() >= 0L ? 1 : 0) != 0, (Object)"scheduleDelayMillis must greater than or equal 0.");
                Utils.checkArgument((config.getExporterTimeoutMillis() >= 0 ? 1 : 0) != 0, (Object)"exporterTimeoutMillis must greater than or equal 0.");
                Utils.checkArgument((config.getMaxQueueSize() > 0 ? 1 : 0) != 0, (Object)"maxQueueSize must be positive.");
                Utils.checkArgument((config.getMaxExportBatchSize() > 0 ? 1 : 0) != 0, (Object)"maxExportBatchSize must be positive.");
                return config;
            }
        }
    }

    private static final class Worker
    implements Runnable {
        private static final LongCounter.BoundLongCounter droppedSpans;
        private final ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory(BatchSpansProcessor.access$400()));
        private static final Logger logger;
        private final SpanExporter spanExporter;
        private final long scheduleDelayMillis;
        private final int maxQueueSize;
        private final int maxExportBatchSize;
        private final int halfMaxQueueSize;
        private final Object monitor = new Object();
        private final int exporterTimeoutMillis;
        @GuardedBy(value="monitor")
        private final List<ReadableSpan> spansList;

        private Worker(SpanExporter spanExporter, long scheduleDelayMillis, int maxQueueSize, int maxExportBatchSize, int exporterTimeoutMillis) {
            this.spanExporter = spanExporter;
            this.scheduleDelayMillis = scheduleDelayMillis;
            this.maxQueueSize = maxQueueSize;
            this.halfMaxQueueSize = maxQueueSize >> 1;
            this.maxExportBatchSize = maxExportBatchSize;
            this.spansList = new ArrayList<ReadableSpan>(maxQueueSize);
            this.exporterTimeoutMillis = exporterTimeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(ReadableSpan span) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.spansList.size() == this.maxQueueSize) {
                    droppedSpans.add(1L);
                    return;
                }
                this.spansList.add(span);
                if (this.spansList.size() >= this.halfMaxQueueSize) {
                    this.monitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                ArrayList<ReadableSpan> spansCopy;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.spansList.size() < this.maxExportBatchSize) {
                        do {
                            try {
                                this.monitor.wait(this.scheduleDelayMillis);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        } while (this.spansList.isEmpty());
                    }
                    spansCopy = new ArrayList<ReadableSpan>(this.spansList);
                    this.spansList.clear();
                }
                this.exportBatches(spansCopy);
            }
        }

        private void shutdown() {
            this.forceFlush();
            this.executorService.shutdown();
            this.spanExporter.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceFlush() {
            ArrayList<ReadableSpan> spansCopy;
            Object object = this.monitor;
            synchronized (object) {
                spansCopy = new ArrayList<ReadableSpan>(this.spansList);
                this.spansList.clear();
            }
            this.exportBatches(spansCopy);
        }

        private void exportBatches(ArrayList<ReadableSpan> spanList) {
            int i = 0;
            while (i < spanList.size()) {
                int batchSizeLimit = Math.min(i + this.maxExportBatchSize, spanList.size());
                this.onBatchExport(Worker.createSpanDataForExport(spanList, i, batchSizeLimit));
                i = batchSizeLimit;
            }
        }

        private static List<SpanData> createSpanDataForExport(List<ReadableSpan> spanList, int startIndex, int numberToTake) {
            ArrayList<SpanData> spanDataBuffer = new ArrayList<SpanData>(numberToTake);
            for (int i = startIndex; i < numberToTake; ++i) {
                spanDataBuffer.add(spanList.get(i).toSpanData());
                spanList.set(i, null);
            }
            return Collections.unmodifiableList(spanDataBuffer);
        }

        private void onBatchExport(final List<SpanData> spans) {
            Future<?> submission = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Worker.this.spanExporter.export(spans);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Exception thrown by the export.", t);
                    }
                }
            });
            try {
                submission.get(this.exporterTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.WARNING, "Exception thrown by the export.", e);
            }
            catch (TimeoutException e) {
                logger.log(Level.WARNING, "Export timed out. Cancelling execution.", e);
                submission.cancel(true);
            }
        }

        static {
            Meter meter = OpenTelemetry.getMeterProvider().get("io.opentelemetry.sdk.trace");
            LongCounter droppedSpansCounter = meter.longCounterBuilder("droppedSpans").setMonotonic(true).setUnit("1").setDescription("The number of spans dropped by the BatchSpansProcessor due to high throughput.").build();
            droppedSpans = droppedSpansCounter.bind(new String[]{"spanProcessorType", BatchSpansProcessor.class.getSimpleName()});
            logger = Logger.getLogger(Worker.class.getName());
        }
    }
}

