/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSamplerBuilder;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class JaegerRemoteSamplerProvider
implements ConfigurableSamplerProvider {
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    static final String SAMPLER_ARG_PROPERTY = "otel.traces.sampler.arg";
    private static final String ENDPOINT_KEY = "endpoint";
    private static final String POLLING_INTERVAL = "pollingInterval";
    private static final String INITIAL_SAMPLING_RATE = "initialSamplingRate";

    public Sampler createSampler(ConfigProperties config) {
        String initialSamplingRate;
        String pollingInterval;
        Map params;
        String endpoint;
        JaegerRemoteSamplerBuilder builder = JaegerRemoteSampler.builder();
        String serviceName = config.getString(SERVICE_NAME_PROPERTY);
        if (serviceName == null) {
            Map resourceAttributes = config.getMap(ATTRIBUTE_PROPERTY);
            serviceName = (String)resourceAttributes.get(SERVICE_NAME_PROPERTY);
        }
        if (serviceName != null) {
            builder.setServiceName(serviceName);
        }
        if ((endpoint = (String)(params = config.getMap(SAMPLER_ARG_PROPERTY)).get(ENDPOINT_KEY)) != null) {
            builder.setEndpoint(endpoint);
        }
        if ((pollingInterval = (String)params.get(POLLING_INTERVAL)) != null) {
            builder.setPollingInterval(Integer.valueOf(pollingInterval), TimeUnit.MILLISECONDS);
        }
        if ((initialSamplingRate = (String)params.get(INITIAL_SAMPLING_RATE)) != null) {
            builder.setInitialSampler(Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)Double.valueOf(initialSamplingRate))));
        }
        return builder.build();
    }

    public String getName() {
        return "jaeger_remote";
    }
}

