/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.ClientInterceptor;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.DefaultGrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcServiceBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.UnMarshaler;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

final class DefaultGrpcServiceBuilder<ReqT extends Marshaler, ResT extends UnMarshaler>
implements GrpcServiceBuilder<ReqT, ResT> {
    private final String type;
    private final Function<ManagedChannel, MarshalerServiceStub<ReqT, ResT, ?>> stubFactory;
    private final String grpcServiceName;
    @Nullable
    private ManagedChannel channel;
    private long timeoutNanos;
    private URI endpoint;
    private boolean compressionEnabled = false;
    @Nullable
    private Metadata metadata;
    @Nullable
    private byte[] trustedCertificatesPem;
    @Nullable
    private byte[] privateKeyPem;
    @Nullable
    private byte[] certificatePem;
    @Nullable
    private RetryPolicy retryPolicy;

    DefaultGrpcServiceBuilder(String type, Function<ManagedChannel, MarshalerServiceStub<ReqT, ResT, ?>> stubFactory, long defaultTimeoutSecs, URI defaultEndpoint, String grpcServiceName) {
        this.type = type;
        this.stubFactory = stubFactory;
        this.grpcServiceName = grpcServiceName;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(defaultTimeoutSecs);
        this.endpoint = defaultEndpoint;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> setChannel(ManagedChannel channel) {
        Objects.requireNonNull(channel, "channel");
        this.channel = channel;
        return this;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        Utils.checkArgument((!timeout.isNegative() ? 1 : 0) != 0, (String)"timeout must be non-negative");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = ExporterBuilderUtil.validateEndpoint((String)endpoint);
        return this;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.compressionEnabled = true;
        return this;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> setTrustedCertificates(byte[] trustedCertificatesPem) {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    @Override
    public GrpcServiceBuilder<ReqT, ResT> setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.privateKeyPem = privateKeyPem;
        this.certificatePem = certificatePem;
        return this;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> addHeader(String key, String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        this.metadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        return this;
    }

    @Override
    public DefaultGrpcServiceBuilder<ReqT, ResT> addRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public GrpcService<ReqT, ResT> build() {
        ManagedChannel channel = this.channel;
        if (channel == null) {
            ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint.getAuthority());
            if (this.endpoint.getScheme().equals("https")) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
            }
            if (this.trustedCertificatesPem != null) {
                try {
                    ManagedChannelUtil.setClientKeysAndTrustedCertificatesPem((ManagedChannelBuilder)managedChannelBuilder, (byte[])this.privateKeyPem, (byte[])this.certificatePem, (byte[])this.trustedCertificatesPem);
                }
                catch (SSLException e) {
                    throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                }
            }
            if (this.retryPolicy != null) {
                managedChannelBuilder.defaultServiceConfig(ManagedChannelUtil.toServiceConfig((String)this.grpcServiceName, (RetryPolicy)this.retryPolicy));
            }
            channel = managedChannelBuilder.build();
        }
        Codec codec = this.compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
        MarshalerServiceStub stub = (MarshalerServiceStub)this.stubFactory.apply(channel).withCompression(codec.getMessageEncoding());
        return new DefaultGrpcService(this.type, channel, stub, this.timeoutNanos);
    }
}

