/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import com.google.common.util.concurrent.Futures;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.exporter.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.UnMarshaler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DefaultGrpcService<ReqMarshalerT extends Marshaler, ResUnMarshalerT extends UnMarshaler>
implements GrpcService<ReqMarshalerT, ResUnMarshalerT> {
    private static final Logger logger = Logger.getLogger(DefaultGrpcService.class.getName());
    private final String type;
    private final ManagedChannel managedChannel;
    private final MarshalerServiceStub<ReqMarshalerT, ResUnMarshalerT, ?> stub;
    private final long timeoutNanos;

    DefaultGrpcService(String type, ManagedChannel channel, MarshalerServiceStub<ReqMarshalerT, ResUnMarshalerT, ?> stub, long timeoutNanos) {
        this.type = type;
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        this.stub = stub;
    }

    @Override
    public ResUnMarshalerT execute(ReqMarshalerT exportRequest, ResUnMarshalerT responseUnmarshaller) {
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        try {
            return (ResUnMarshalerT)((UnMarshaler)Futures.getUnchecked((Future)stub.export(exportRequest)));
        }
        catch (Throwable t) {
            Status status = Status.fromThrowable((Throwable)t);
            if (status.getCode().equals((Object)Status.Code.UNIMPLEMENTED)) {
                logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. Server responded with UNIMPLEMENTED. Full error message: " + status.getDescription());
            } else if (status.getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. Server is UNAVAILABLE. Make sure your service is running and reachable from this network. Full error message:" + status.getDescription());
            } else {
                logger.log(Level.WARNING, "Failed to execute " + this.type + "s. Server responded with gRPC status code " + status.getCode().value() + ". Error message: " + status.getDescription());
            }
            return responseUnmarshaller;
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.managedChannel.isTerminated()) {
            return CompletableResultCode.ofSuccess();
        }
        return ManagedChannelUtil.shutdownChannel((ManagedChannel)this.managedChannel);
    }
}

